package smart_gs.logical;

import smart_gs.GSConstants;
import smart_gs.reasoning_web.logical.ExpNoteManager;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

/**
 * 
 * Ƃ̂
 *
 */
public class URISolver {
	
	public static Region getRegion(String uri){
		Region region = null;
		Spread spread = SpreadTree.getInstance().getSpreadByURI(uri);
		if(spread == null){
			return null;
		}
		region = spread.getRegionByURI(uri);
		return region;
	}
	public static Note getNote(String uri){
		Note note = NoteTree.getInstance().getNoteByURI(uri);
		return note;
	}
	public static GSResource getPresentation(String uri){
		GSResource present = PresentationTree.getInstance().getPresentationByURI(uri);
		return present;
	}
	public static GSResource getSpreadResource(String uri){
		Spread spread = SpreadTree.getInstance().getSpreadByURI(uri);
		GSResource resource = spread.getResource(uri);
		return resource;
	}
	
	// 20080909 hashimoto wrote
	public static Spread getSpread(String uri){
		Spread spread = SpreadTree.getInstance().getSpreadByURI(uri);
		return spread;
	}
	
	public static GSResource getResource(String uri){
		GSResource resource = null;
		if(uri.contains(GSConstants.URI_HEADER+"note/")){
			return getNote(uri);
		}
		if(uri.contains(GSConstants.URI_HEADER+"presentation/")){
			return getPresentation(uri);
		}
		if(uri.contains("explanatory")){
			return ExpNoteManager.getInstance().getResource(uri);
		}else if(uri.contains("package")){
			return null;
		}else if(uri.contains("document")){
			return ReasoningWebFrame.getInstance().getDesktopPanel().getResource(uri);
		}
		
		resource = getSpreadResource(uri);
		if(resource != null){
			return resource;
		}
		
		return resource;
	}
	
	
}
