package smart_gs.menu;

import javax.swing.JMenuItem;
import javax.swing.JMenu;
import javax.swing.KeyStroke;

import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.action.ImageSearchActionListener;
import smart_gs.swingui.toolbar.action.Text2ImageActionListener;
import smart_gs.swingui.toolbar.action.TextSearchActionListener;

public class SearchMenu extends JMenu {
	
	public SearchMenu(String title, AbstractGSWindow parent){
		super(title);
		JMenuItem imageSearch = new JMenuItem("ImageSearch");
		imageSearch.addActionListener(new ImageSearchActionListener(parent));
		imageSearch.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
		this.add(imageSearch);
		
		JMenuItem text2Image = new JMenuItem("Text-Image");
		text2Image.addActionListener(new Text2ImageActionListener());
//		this.add(text2Image);
		JMenuItem textSearch = new JMenuItem("TextSearch");
		textSearch.addActionListener(new TextSearchActionListener());
		this.add(textSearch);
	}

}
