package smart_gs.smleditor.swingui;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.swingui.toolbar.GSMarkupAction;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.toolbar.action.CopyAction;
import sml_editor.swingui.toolbar.action.CutAction;
import sml_editor.swingui.toolbar.action.MarkupAction;
import sml_editor.swingui.toolbar.action.PasteAction;

@SuppressWarnings("serial")
public class GSEditorPopupMenu2 extends JPopupMenu{	
	protected MarkupAction markupAction;
	protected CopyAction copyAction;
	protected CutAction cutAction;
	protected PasteAction pasteAction;

	public GSEditorPopupMenu2(EditorTextPane textPane) {
		if(textPane.isMarkup()){
			markupAction = new GSMarkupAction();
			markupAction.setEditorTextPane(textPane);
			JMenuItem markup = new JMenuItem("mark up");
			markup.addActionListener(markupAction);
			this.add(markup);
		}
		copyAction = new CopyAction();
		copyAction.setEditorTextPane(textPane);
		JMenuItem copy = new JMenuItem("copy");
		copy.addActionListener(copyAction);
		this.add(copy);

		cutAction = new CutAction();
		cutAction.setEditorTextPane(textPane);
		JMenuItem cut = new JMenuItem("cut");
		cut.addActionListener(cutAction);
		this.add(cut);

		pasteAction = new PasteAction();
		pasteAction.setEditorTextPane(textPane);
		JMenuItem paste = new JMenuItem("paste");
		paste.addActionListener(pasteAction);
		this.add(paste);

	}
	
	
	
}
