/*
GNU Lesser General Public License

FormatAction
Copyright (C) 2000 Howard Kistler

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

package smart_gs.spread_selection;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;

import com.hexidec.ekit.GSHTMLEditor;
import com.hexidec.ekit.component.SimpleInfoDialog;


/** Class for implementing HTML format actions
 * (NOTE : Does not toggle. User must use the "Clear Format" option to remove formatting correctly.)
 */
public class MarkupUtil 
{
	protected GSHTMLEditor parentEkit;
	HTML.Tag htmlTag;
	protected int maxlength;
	protected ArrayList attrList = new ArrayList();
	public MarkupUtil(GSHTMLEditor ekit, int maxlength)
	{
		parentEkit = ekit;
		this.maxlength = maxlength;
	}

	public boolean check(int start,int end){
		JTextPane parentTextPane = parentEkit.getTextPane();
		parentTextPane.setSelectionStart(start);
		parentTextPane.setSelectionEnd(end);
		for(int i=start;i<=end;i++){
			parentTextPane.setSelectionStart(i);
			parentTextPane.setSelectionEnd(i);
			SimpleAttributeSet sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(HTML.Tag.A.toString())){
					return true;
				}
			}
		}
		parentTextPane.setSelectionStart(start);
		parentTextPane.setSelectionEnd(end);
		return false;
	}	
	public void releasMakup(){
		parentEkit.stopDocumentListener();
		JTextPane parentTextPane = parentEkit.getTextPane();
		int textStart =  parentTextPane.getCaretPosition();
		int start = textStart;
		start++;
		int end   = textStart;
		SimpleAttributeSet sasText = null;
		// O@`FbN
		for(int i=textStart;i<maxlength;i++){
			parentTextPane.setSelectionStart(i);
			sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
			Enumeration attribEntries1 = sasText.getAttributeNames();
			boolean check = false;
			while(attribEntries1.hasMoreElements()){
				Object entryKey   = attribEntries1.nextElement();
				Object entryValue = sasText.getAttribute(entryKey);
				if(entryKey.toString().equals(HTML.Tag.A.toString())){
					sasText.removeAttribute(entryKey);
					end++;
					check = true;
					parentTextPane.select(i, i + 1);
					parentTextPane.setCharacterAttributes(sasText, true);
				}
			}
			if(!check){
				break;
			}
		}
		// `FbN
		if((textStart - 1) != 0){
			for(int i=(textStart - 1);i>0;i--){
				parentTextPane.setSelectionStart(i);
				parentTextPane.setSelectionEnd(i);
				sasText = new SimpleAttributeSet(parentTextPane.getCharacterAttributes());
				Enumeration attribEntries1 = sasText.getAttributeNames();
				boolean check = false;
				while(attribEntries1.hasMoreElements()){
					Object entryKey   = attribEntries1.nextElement();
					Object entryValue = sasText.getAttribute(entryKey);
					if(entryKey.toString().equals(HTML.Tag.A.toString())){
						sasText.removeAttribute(entryKey);
						start--;
						check = true;
						parentTextPane.select(i, i + 1);
						parentTextPane.setCharacterAttributes(sasText, true);
					}
				}
				if(!check){
					break;
				}
			}
		}
		parentEkit.startDocumentListener();
		parentEkit.learn();
		parentTextPane.setSelectionStart(start);
		parentTextPane.setSelectionEnd(end);
	}

}

