package smart_gs.swingui;

import javax.swing.JTabbedPane;

import org.xml.sax.SAXException;

import smart_gs.logical.SmartDocument;
import smart_gs.smleditor.swingui.GSBrowsePanel;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygPanel;
import sml_editor.swingui.AbstractEditorPanel;
import sml_editor.swingui.EditorFrame;
import sml_editor.swingui.SourcePanel;

@SuppressWarnings("serial")
public class GSTabbedPane extends JTabbedPane{
	
	
	protected AbstractEditorPanel browsePanel;
	protected AbstractEditorPanel wysiwygPanel;
	
	protected GSEditorTextPane textPane;
	
	protected SourcePanel sourcePanel;
	protected EditorFrame parent;
	protected SmartDocument document;
	
	public GSTabbedPane(SmartDocument document,EditorFrame parent){
		super();
		this.document = document;
//		try {
//			this.controller = new SmlController(document.getSource());
			
			this.parent = parent;

			this.init(parent);
//		} catch (SAXException e) {
//			e.printStackTrace();
//		}
	}
	private void init(EditorFrame parent){
		this.textPane = new GSEditorTextPane(this.document,GSEditorTextPane.BASIC);
		this.browsePanel = new GSBrowsePanel(parent, textPane);
		this.addTab("Browse",this.browsePanel);
		this.wysiwygPanel = new GSWysiwygPanel(parent, textPane);
		this.addTab("Wysiwyg",this.wysiwygPanel);
		
		this.sourcePanel = new SourcePanel(parent);
		this.addTab("Source",this.sourcePanel);
		
		this.setSelectedComponent(this.wysiwygPanel);
	}
	public GSEditorTextPane getTextPane(){
		return this.textPane;
	}
//	public SmlController getController() {
//		return this.controller;
//	}
	//20071215 shimizu wrote;
	public void emphasize(String id){
		this.textPane.getGSHTMLEditorTextPane().emphasize(id);
	}
	//
}
