/*
 * 쐬F 2004/10/12
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package sml_editor.node;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * @author kawamura
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class SmlText extends SmlChildNode {

	private Text fText;
	
	public SmlText(Text text) {
		fText = text;
		fLength = calculateLength();
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#getNode()
	 */
	public Node getNode() {
		return fText;
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#getNodeName()
	 */
	public String getNodeName() {
		return fText.getNodeName();
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#setNodeValue(java.lang.String)
	 */
	public void setNodeValue(String nodeValue) {
		int oldLength = fLength;
		fText.setData(nodeValue);
		fLength = calculateLength();
		if(fParent != null) {
			fParent.plusLength(fLength - oldLength);
		}
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLChildNode#caluculateLength()
	 */
	protected int calculateLength() {
		return fText.getLength();
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#getNodeType()
	 */
	public short getNodeType() {
		return SmlNode.TEXT_NODE;
	}

	/* (Javadoc Ȃ)
	 * @see editor.node.SMLNode#getNodeValue()
	 */
	public String getNodeValue() {
		return fText.getNodeValue();
	}

	public SmlText splitText(int offset) {
		SmlText brother = new SmlText(fText.splitText(offset));
		fParent.insertBefore2(brother, this.getNextSibling());
		fLength = calculateLength();
		fParent.plusLength(-1 * brother.getLength());
		return brother;
	}

	/* (Javadoc Ȃ)
	 * @see org.w3c.dom.CharacterData#substringData(int, int)
	 */
	public String substringData(int offset, int count) throws DOMException {
		return fText.substringData(offset, count);
	}

	/* (Javadoc Ȃ)
	 * @see org.w3c.dom.CharacterData#insertData(java.lang.String)
	 */
	public void appendData(String arg) throws DOMException {
		insertData(getNodeValue().length(), arg);
	}

	/* (Javadoc Ȃ)
	 * @see org.w3c.dom.CharacterData#insertData(int, java.lang.String)
	 */
	public void insertData(int offset, String arg) throws DOMException {
		fText.insertData(offset, arg);
		fLength += arg.length();
		fParent.plusLength(arg.length());
	}
	
	/* (Javadoc Ȃ)
	 * @see org.w3c.dom.CharacterData#deleteData(int, int)
	 */
	public void deleteData(int offset, int count) throws DOMException {
	//	String delData = fText.substringData(offset, count);
		int oldLength = calculateLength();
		fText.deleteData(offset, count);
		fLength = calculateLength();
		fParent.plusLength(fLength - oldLength);
	}
}
