# -*- coding: utf-8 -*-
class SessionsController < ApplicationController
  skip_before_filter :authorize, only: [:new, :create, :destroy]

  # ログイン
  #
  # 認証に成功したらセッションを作成する
  def create
    if params[:language]
      redirect_to login_url(locale: params[:language][:locale])
      return
    end

    user = User.find_by_email(params[:email])
    if user and user.authenticate(params[:password])

      # ユーザが無効な場合、ログインさせない
      unless user.is_active
        redirect_to login_url, alert: t('errors.messages.this_acount_is_not_activated')
        return
      end

      session[:user_id] = user.id
      session[:tz] =
        user.timezone.nil? ? DefaultConfig.all.first.timezone : user.timezone

      redirect_to tickets_url(locale: user.locale)
    else
      redirect_to login_url, alert: t('errors.sessions.invalid_email_password_combination')
    end
  end

  # ログアウト
  #
  # セッションを破棄する
  def destroy
    session[:user_id] = nil
    redirect_to login_url, notice: t('sessions.logout')
  end
end
