# -*- coding: utf-8 -*-
module TicketsHelper

  def item_link(ticket, title, class_name = 'item_link')
    link_to raw(title), ticket_path(id: ticket.id), remote: true, class: class_name
  end

  def id_link(ticket, is_unread)
    class_name = is_unread ? 'unread_item_link' : 'item_link'
    item_link(ticket, '#' + ticket.id.to_s, class_name)
  end

  def title_link(ticket, is_unread)
    class_name = is_unread ? 'unread_item_link' : 'item_link'
    item_link(ticket, ticket.title, class_name)
  end

  def assigned_user(ticket)
    assigned_user = ticket.assigned_user
    return assigned_user ? assigned_user.handle : nil
  end

  def created_by(ticket)
    create_user = ticket.created_by
    return create_user ? create_user.handle : ''
  end

  def state_icon(ticket, all_states)
    state = all_states[ticket.state_id - 1]
    image_tag('state_' + state.id.to_s + '.png',
              alt: 'state: ' + state.label,
              title: state.label)
  end

  def priority_icon(ticket, all_priorities)
    priority = all_priorities[ticket.priority_id - 1]
    image_tag('priority_' + priority.id.to_s + '.png',
              alt: 'priority: ' + priority.label,
              title: priority.label)
  end

  def workload_icon(ticket, all_workloads)
    workload = all_workloads[ticket.workload_id - 1]
    image_tag('workload_' + workload.id.to_s + '.png',
              alt: 'workload: ' + workload.id.to_s,
              title: workload.label)
  end

  def new_ticket_link(project_id, title)
    link_to title, new_ticket_path(project_id: project_id), remote: true, class: 'item_link'
  end

  def projects_ticket_link(project, title)
    link_to title, tickets_path(project_id: project.id)
  end

  def state_icon_and_label(ticket, state)
    image_tag('state_' + state.id.to_s + '.png',
              alt: 'state: ' + state.label,
              title: state.label) + ' ' + state.label
  end

  def priority_icon_and_label(ticket, priority)
    image_tag('priority_' + priority.id.to_s + '.png',
              alt: 'priority: ' + priority.label,
              title: priority.label) + ' ' + priority.label

  end

  def workload_icon_and_label(ticket, workload)
    image_tag('workload_' + workload.id.to_s + '.png',
              alt: 'workload: ' + workload.id.to_s,
              title: workload.label) + ' ' + workload.label
  end

  def attributes_changed_log(log)
    output = ''

    output += '<span class="attribute_log">title changed to:</span> ' + log.title + ', ' if log.title
    output += '<span class="attribute_log">project changed to:</span> ' +
      log.project.title + ', ' if log.project_id
    output += '<span class="attribute_log">state changed to:</span> ' + log.state.label + ', ' if log.state_id
    output += '<span class="attribute_log">priority changed to:</span> ' +
      log.priority.label + ', ' if log.priority_id
    output += '<span class="attribute_log">workload changed to:</span> ' +
      log.workload.label + ', ' if log.workload_id
    output += '<span class="attribute_log">assigned user changed to:</span> ' +
      log.assigned_user.handle + ', ' if log.assigned_user_id

    return raw(output)
  end
end
