DefaultConfig.create(id: 1,
                     locale: 'en',
                     timezone: 'UTC')

State.create(id: 1, label: "Open")
State.create(id: 2, label: "Resolved")
State.create(id: 3, label: "Rejected")

Priority.create(id: 1, label: 'Critical')
Priority.create(id: 2, label: 'Major')
Priority.create(id: 3, label: 'Minor')
Priority.create(id: 4, label: 'Trivial')

Workload.create(id: 1, workload: 1, label: 'Easy')
Workload.create(id: 2, workload: 3, label: 'Possible')
Workload.create(id: 3, workload: 5, label: 'Difficult')


=begin
# test data
User.create(id: 1,
            email: 'admin@mail.address.com',
            password_digest: BCrypt::Password.create('admin'),
            handle: 'admin',
            is_active: true,
            is_admin: true,
            is_resolved_show: false,
            locale: 'en',
            timezone: nil,
            project_order_csv: '')
User.create(id: 2,
            email: 'someone@mail.address.com',
            password_digest: BCrypt::Password.create('secret'),
            handle: 'someone',
            is_active: true,
            is_admin: false,
            is_resolved_show: false,
            locale: 'en',
            timezone: nil,
            project_order_csv: '2,1')

test_project = Project.create(id: 1,
                              title: 'Test',
                              description: 'This is test project.',
                              is_active: true,
                              is_group: false,
                              is_open: false,
                              created_by_user_id: 2)
Project.create(id: 2,
               title: 'No ticket project',
               description: "This project don't have a ticket.",
               is_active: true,
               is_group: false,
               is_open: false,
               created_by_user_id: 2)
Project.create(id: 3,
               title: 'Private project',
               description: 'This is private project.',
               is_active: true,
               is_group: false,
               is_open: false,
               created_by_user_id: 2)
Project.create(id: 4,
               title: 'Another user project',
               description: 'This is another user project.',
               is_active: true,
               is_group: false,
               is_open: false,
               created_by_user_id: 1)

Ticket.create(id: 1,
              title: 'assigned ticket',
              comment: 'This ticket is assigned to some user.',
              project_id: 1,
              state_id: 1,
              priority_id: test_project.id,
              workload_id: 1,
              assigned_user_id: 2,
              updated_by_user_id: 2)
Ticket.create(id: 2,
              title: 'not assigned ticket',
              comment: 'This ticket is not assigned to any user.',
              project_id: test_project.id,
              state_id: 1,
              priority_id: 2,
              workload_id: 2,
              assigned_user_id: nil,
              updated_by_user_id: 2)
Ticket.create(id: 3,
              title: 'no comment ticket',
              comment: '',
              project_id: test_project.id,
              state_id: 1,
              priority_id: 3,
              workload_id: 3,
              assigned_user_id: nil,
              updated_by_user_id: 2)
Ticket.create(id: 4,
              title: 'trivial ticket',
              comment: '',
              project_id: test_project.id,
              state_id: 1,
              priority_id: 4,
              workload_id: 3,
              assigned_user_id: nil,
              updated_by_user_id: 2)
Ticket.create(id: 5,
              title: 'priority 3 ticket',
              comment: 'priority 3',
              project_id: test_project.id,
              state_id: 1,
              priority_id: 3,
              workload_id: 1,
              assigned_user_id: 2,
              updated_by_user_id: 2)
Ticket.create(id: 6,
              title: 'resolved ticket',
              comment: 'resoleved (completed)',
              project_id: test_project.id,
              state_id: 2,
              priority_id: 3,
              workload_id: 1,
              assigned_user_id: 2,
              updated_by_user_id: 2)
Ticket.create(id: 7,
              title: 'resolved ticket',
              comment: 'resoleved (rejected)',
              project_id: test_project.id,
              state_id: 3,
              priority_id: 3,
              workload_id: 1,
              assigned_user_id: 2,
              updated_by_user_id: 2)
ticket = Ticket.create(id: 8,
                       title: 'default parameter',
                       comment: 'original message',
                       project_id: test_project.id,
                       state_id: 2,
                       priority_id: 3,
                       workload_id: 1,
                       assigned_user_id: nil,
                       updated_by_user_id: 2)
ticket.update_attributes(title: 'this title is updated',
                         comment: 'this message is updated')
ticket.update_attributes(state_id: 1)
ticket.update_attributes(priority_id: 2)
ticket.update_attributes(workload_id: 2)
ticket.update_attributes(assigned_user_id: 2)
ticket.update_attributes(comment: '2nd update')

project = Project.create(id: 7,
                         title: 'For chart test project (many)',
                         description: 'Too many data',
                         is_active: true,
                         is_group: false,
                         is_open: false,
                         created_by_user_id: 2)

35.times { |i|
  CompletedWorkloads.create(project_id: project.id,
                            priority_id: 1,
                            date: Date.today - i,
                            total: 80 - i,
                            completed: 79 - 2 * i)
}

project = Project.create(id: 8,
                         title: 'For chart test project (few)',
                         description: 'Few data',
                         is_active: true,
                         is_group: false,
                         is_open: false,
                         created_by_user_id: 2)

3.times { |i|
  CompletedWorkloads.create(project_id: project.id,
                            priority_id: 2,
                            date: Date.today - i,
                            total: 20 - i,
                            completed: 20 - 2 * i)
}
=end
