﻿using System;
using System.Globalization;
using System.IO;
using System.Text;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Icc
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class LocalizedString
	{
		#region private fields
		private readonly string languageCode;
		private readonly string regionCode;
		private readonly uint length;
		private readonly uint offset;
		private readonly string text;
		#endregion

		// public プロパティ //

		/// <summary>
		/// 
		/// </summary>
		public CultureInfo Culture
		{
			get {
				return new CultureInfo(this.CultureName);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public string CultureName
		{
			get {
				return this.languageCode + "-" + regionCode;
			}
		}

		// internal コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal LocalizedString(BinaryReaderNeo reader, long basePosition)
		{
			this.languageCode = reader.ReadString(2);
			this.regionCode = reader.ReadString(2);
			this.length = reader.ReadUInt32();
			this.offset = reader.ReadUInt32();
			using (reader.KeepPosition()) {
				reader.Position = basePosition + this.offset;
				byte[] bytes = reader.ReadBytes((int)this.length);
				this.text = Encoding.BigEndianUnicode.GetString(bytes);
			}
		}

		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("{Text=");
			new QuotedStringFormatter().WriteTo(sw, this.text);
			sw.Write(", Culture=");
			try {
				sw.Write(this.Culture.DisplayName);
			} catch (ArgumentException) {
				sw.Write(this.CultureName);
			}
			sw.Write("}");
			return sw.ToString();
		}
	}
}
