using System;
using System.IO;

using SystemNeo.IO;

namespace SystemNeo.Drawing.Imaging.Icc
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class Measurement
	{
		#region private fields
		private readonly MeasurementObserver observer;
		private readonly Fraction[] backing;
		private readonly uint geometry;
		private readonly Fraction flare;
		private readonly IlluminantType illuminantType;
		#endregion

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal Measurement(BinaryReaderNeo reader)
		{
			this.observer = (MeasurementObserver)reader.ReadUInt32();
			this.backing = IccUtil.ReadFractions(reader, 3);
			this.geometry = reader.ReadUInt32();
			this.flare = IccUtil.ReadFraction(reader);
			this.illuminantType = (IlluminantType)reader.ReadUInt32();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("{Observer=");
			sw.Write(this.observer);
			sw.Write(", Backing=");
			IccUtil.fractionArrayFormatter.WriteTo(sw, this.backing);
			sw.Write(", Geometry=");
			sw.Write(this.geometry);
			sw.Write(", Flare=");
			FractionFormatter.Default.WriteTo(sw, this.flare);
			sw.Write(", IlluminantType=");
			sw.Write(this.illuminantType);
			sw.Write("}");
			return sw.ToString();
		}
	}
}
