using System;
using System.IO;

using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Drawing.Imaging.Jfif
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class SosSegmentContent : SegmentContent
	{
		#region private fields
		private readonly byte startSpectralSelection;
		private readonly byte endSpectralSelection;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public int Approx { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public Component[] Components { get; private set; }

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reader"></param>
		internal SosSegmentContent(BinaryReaderNeo reader)
		{
			int count = reader.ReadByte();
			this.Components = new Component[count];
			for (int i = 0; i < count; i++) {
				var componentId = (YCbCrComponent)reader.ReadByte();
				this.Components[i] = new Component(componentId, reader.ReadByte());
			}
			this.startSpectralSelection = reader.ReadByte();
			this.endSpectralSelection = reader.ReadByte();
			this.Approx = reader.ReadByte();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			var sw = new StringWriter();
			sw.Write("Components=");
			new CollectionFormatter().WriteTo(sw, this.Components);
			sw.Write(", SpectralSelection=[");
			sw.Write(this.startSpectralSelection);
			sw.Write(", ");
			sw.Write(this.endSpectralSelection);
			sw.Write("], Approx=0x");
			sw.Write(this.Approx.ToString("X2"));
			return sw.ToString();
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public struct Component
		{
			#region private fields
			private readonly YCbCrComponent componentId;
			private readonly byte dcId;
			private readonly byte acId;
			#endregion

			// public vpeB //

			/// <summary>
			/// 
			/// </summary>
			public YCbCrComponent ComponentId
			{
				get {
					return this.componentId;
				}
			}

			/// <summary>
			/// 
			/// </summary>
			public int HuffmanTableAcId
			{
				get {
					return this.acId;
				}
			}

			/// <summary>
			/// 
			/// </summary>
			public int HuffmanTableDcId
			{
				get {
					return this.dcId;
				}
			}

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="componentId"></param>
			/// <param name="huffmanTableId"></param>
			internal Component(YCbCrComponent componentId, byte huffmanTableId)
			{
				this.componentId = componentId;
				ObjectUtil.SplitBits(huffmanTableId, out this.dcId, out this.acId);
			}

			// public \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			public override string ToString()
			{
				var sw = new StringWriter();
				sw.Write("{");
				sw.Write(this.componentId);
				sw.Write(", ");
				sw.Write(this.dcId);
				sw.Write(", ");
				sw.Write(this.acId);
				sw.Write("}");
				return sw.ToString();
			}
		}
	}
}
