using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Forms;
using System.Xml;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="TElement"></typeparam>
	/// <typeparam name="TNode"></typeparam>
	public abstract class AbstractTreeViewBinding<TElement, TNode>
			where TElement : class where TNode : DataTreeNode<TElement>
	{
		protected TElement root;
		protected TreeView treeView;

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public TreeView TreeView
		{
			get {
				return this.treeView;
			}
			set {
				if (value != this.treeView) {
					if (this.treeView != null) {
						this.treeView.AfterCollapse -= AfterCollapse;
						this.treeView.BeforeExpand -= this.BeforeExpand;
					}
					this.treeView = value;
					if (this.treeView != null) {
						this.treeView.AfterCollapse += AfterCollapse;
						this.treeView.BeforeExpand += this.BeforeExpand;
						this.CreateTree();
					}
				}
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		public void Added(TElement element)
		{
			ArgumentUtil.AssertNull(element, "element");
			TElement parent = this.GetParent(element);
			if (parent == this.root) {
				this.AddedInternal(element, parent, this.treeView.Nodes);
			} else {
				TNode parentNode = this.GetElementNode(parent, false);
				if (parentNode != null) {
					if (parentNode.IsExpanded) {
						this.AddedInternal(element, parent, parentNode.Nodes);
					} else {
						TreeViewUtil.SetPlusVisible(parentNode, true);
					}
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		public void CreateSubTree(TNode node)
		{
			ArgumentUtil.AssertNull(node, "node");
			if (this.HasChildren(node.Data) && node.Nodes.Count == 0) {
				this.CreateSubTreeInternal(node);
				foreach (DataTreeNode<TElement> childNode in node.Nodes) {
					TreeViewUtil.SetPlusVisible(childNode, this.HasChildren(childNode.Data));
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <param name="allowCreate"></param>
		/// <returns></returns>
		public TNode GetElementNode(TElement element, bool allowCreate)
		{
			if (this.IsTopLevel(element)) {
				// XMLvf[gvf̒̏ꍇ́Ac[r[̍ŏʂ̃m[h̒T
				return GetElementNodeInternal(this.treeView.Nodes, element);
			} else {
				// ܂eXMLvfɑΉc[m[hT
				TNode parentNode = this.GetElementNode(this.GetParent(element), allowCreate);
				// 
				if (parentNode == null) {
					return null;
				}
				if (allowCreate) {
					this.CreateSubTree(parentNode);
				}
				// ẽc[m[h̉ɁATĂXMLvfɑΉc[m[h͂
				return GetElementNodeInternal(parentNode.Nodes, element);
			}
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <param name="parent"></param>
		/// <param name="treeNodes"></param>
		/// <returns></returns>
		protected bool AddedInternal(
				TElement element, TElement parent, TreeNodeCollection treeNodes)
		{
			TreeNode newNode = this.CreateTreeNode(element);
			bool result = (newNode != null);
			if (result) {
				int index = CollectionUtil.IndexOf(this.GetChildren(parent), element);
				Debug.Assert(index >= 0);
				treeNodes.Insert(index, newNode);
				TreeViewUtil.SetPlusVisible(newNode, this.HasChildren(element));
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		protected abstract void CreateSubTreeInternal(TNode node);

		/// <summary>
		/// 
		/// </summary>
		protected void CreateTree()
		{
			this.treeView.BeginUpdate();
			try {
				this.treeView.Nodes.Clear();
				if (this.root != null) {
					this.CreateTreeInternal(this.root);
					TreeNodeCollection nodes = this.treeView.Nodes;
					TreeViewUtil.SetPlusVisible(nodes, true);
				}
			} finally {
				this.treeView.EndUpdate();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		protected abstract void CreateTreeInternal(TElement element);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected abstract TreeNode CreateTreeNode(object element);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected abstract IEnumerable<TElement> GetChildren(TElement element);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="nodes"></param>
		/// <param name="element"></param>
		/// <returns></returns>
		protected TNode GetElementNodeInternal(TreeNodeCollection nodes, TElement element)
		{
			foreach (TNode node in nodes) {
				if (IsSame(node.Data, element)) {
					return node;
				}
			}
			return null;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected abstract TElement GetParent(TElement element);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected abstract bool HasChildren(TElement element);

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected virtual bool IsSame(TElement x, TElement y)
		{
			return x == y;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="element"></param>
		/// <returns></returns>
		protected abstract bool IsTopLevel(TElement element);

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private static void AfterCollapse(object sender, TreeViewEventArgs e)
		{
			if (e.Node != null) {
				using (new WaitCursor()) {
					e.Node.Nodes.Clear();
					TreeViewUtil.SetPlusVisible(e.Node, true);
				}
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void BeforeExpand(object sender, TreeViewCancelEventArgs e)
		{
			if (e.Node == null || e.Cancel) {
				return;
			}
			using (new WaitCursor()) {
				this.CreateSubTree((TNode)e.Node);
				TreeViewUtil.SetPlusVisible(e.Node, (e.Node.FirstNode != null));
			}
		}
	}
}
