using System;
using System.Collections;
using System.Threading;
using System.Windows.Forms;

using SystemNeo;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// I[gRv[g@\R{{bNXłB
	/// </summary>
	public class AutoCompleteComboBox : ComboBox
	{
		#region private fields
		private string previousText = string.Empty;
		private Thread searchThread;
		#endregion

		// public Cxg //

		/// <summary>
		/// 
		/// </summary>
		public event ThreadExceptionEventHandler Error;

		/// <summary>
		/// IƔ܂B
		/// </summary>
		public event SearchEventHandler Searched;

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public AutoCompleteComboBox() : base()
		{
			this.DropDownStyle = ComboBoxStyle.Simple;
			if (! this.DesignMode) {
				this.KeyUp += this.HandleKeyUp;
			}
		}

		// public \bh //

		/// <summary>
		/// Jn܂B
		/// </summary>
		public void StartSearch()
		{
			if (this.Text != this.previousText) {
				this.AbortSearchThread();
				this.Items.Clear();
				this.searchThread = new Thread(() => this.Search(this.Text));
				this.searchThread.IsBackground = true;
				this.searchThread.Start();
				this.previousText = this.Text;
			}
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="disposing"></param>
		protected override void Dispose(bool disposing)
		{
			this.AbortSearchThread();
			base.Dispose(disposing);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="ex"></param>
		protected virtual void DoError(Exception ex)
		{
			if (this.Error != null) {
				this.Error(this, new ThreadExceptionEventArgs(ex));
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="e"></param>
		protected virtual void DoSearched(SearchEventArgs e)
		{
			if (this.Searched != null) {
				this.Searched(this, e);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="e"></param>
		protected virtual void SearchInternal(SearchEventArgs e) {}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		private void AbortSearchThread()
		{
			Thread thread = this.searchThread;
			this.searchThread = null;
			if (thread != null && thread.IsAlive) {
				thread.Abort();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="thread"></param>
		/// <param name="item"></param>
		private void AddItem(Thread thread, object item)
		{
			if (thread == this.searchThread) {
				ControlUtil.Invoke<object, int>(this, this.Items.Add, item);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void HandleKeyUp(object sender, KeyEventArgs e)
		{
			switch (e.KeyCode) {
			case Keys.Up:
			case Keys.Down:
				break;
			default:
				this.StartSearch();
				break;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="text"></param>
		private void Search(string text)
		{
			try {
				var e = new SearchEventArgs(this.AddItem, text);
				this.SearchInternal(e);
				this.DoSearched(e);
			} catch (ThreadAbortException) {
			} catch (Exception ex) {
				this.DoError(ex);
			}
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public class SearchEventArgs : EventArgs
		{
			#region private fields
			private readonly Action<Thread, object> addItemAction;
			private readonly Thread thread;
			#endregion

			// public vpeB //

			/// <summary>
			/// 
			/// </summary>
			public string Text { get; private set; }

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="addItemAction"></param>
			/// <param name="text"></param>
			internal SearchEventArgs(Action<Thread, object> addItemAction, string text)
			{
				this.thread = Thread.CurrentThread;
				this.addItemAction = addItemAction;
				this.Text = text;
			}

			// public \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="item"></param>
			public void AddItem(object item)
			{
				if (this.addItemAction != null) {
					this.addItemAction(this.thread, item);
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public delegate void SearchEventHandler(object sender, SearchEventArgs e);
	}
}
