using System;
using System.Collections;
using System.Collections.Generic;
using System.Windows.Forms;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// 
	/// </summary>
	public class MenuTreeManager : TreeManager
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public static readonly MenuTreeManager Default = new MenuTreeManager();

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		public override void AddChild(object parent, object child)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(Menu));
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(child, "child", typeof(MenuItem));
			((Menu)parent).MenuItems.Add((MenuItem)child);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public MenuItem FindFirst(Menu baseNode, Func<MenuItem, bool> match)
		{
			return base.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public MenuItem FindFirst(Menu baseNode, Func<MenuItem, bool> match, int depth)
		{
			return base.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public MenuItem FindFirst(Menu baseNode,
				Func<MenuItem, bool> match, TreeSearchAlgorithm algorithm, int depth)
		{
			return base.FindFirst(baseNode, match, algorithm, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override IEnumerable GetChildren(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(Menu));
			return ((Menu)node).MenuItems;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override object GetParent(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(Menu));
			if (node is MenuItem) {
				return ((MenuItem)node).Parent;
			} else {
				return null;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="index"></param>
		public override void Insert(object parent, object child, int index)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(Menu));
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(child, "child", typeof(MenuItem));
			if (index < 0) {
				throw new ArgumentOutOfRangeException("index");
			}
			var items = ((Menu)parent).MenuItems;
			if (index < items.Count) {
				items.Add(index, (MenuItem)child);
			} else {
				items.Add((MenuItem)child);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparer"></param>
		public void InsertSorted(Menu parent, MenuItem child, IComparer<MenuItem> comparer)
		{
			base.InsertSorted(parent, child, comparer);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparison"></param>
		public void InsertSorted(Menu parent, MenuItem child, Comparison<MenuItem> comparison)
		{
			base.InsertSorted(parent, child, comparison);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		public override void RemoveAllChildren(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(Menu));
			((Menu)node).MenuItems.Clear();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		public override void RemoveChild(object parent, object child)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(Menu));
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(child, "child", typeof(MenuItem));
			((Menu)parent).MenuItems.Remove((MenuItem)child);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparer"></param>
		/// <param name="recurse"></param>
		public void Sort(Menu node, IComparer<MenuItem> comparer, bool recurse)
		{
			base.Sort(node, comparer, recurse);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparison"></param>
		/// <param name="recurse"></param>
		public void Sort(Menu node, Comparison<MenuItem> comparison, bool recurse)
		{
			base.Sort(node, comparison, recurse);
		}
	}
}
