using System;
using System.Drawing;
using System.Windows.Forms;

using SystemNeo;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// sN`{bNXRg[Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class PictureBoxUtil
	{
		// public static \bh //

		/// <summary>
		/// sN`{bNX̃TCYAC[W̃TCYƊg嗦猈肵܂B
		/// </summary>
		/// <param name="pictureBox"></param>
		/// <param name="zoomRatio">g嗦B1.0 ͌\܂B</param>
		public static void Zoom(PictureBox pictureBox, double zoomRatio)
		{
			ArgumentUtil.AssertNull(pictureBox, "pictureBox");
			if (zoomRatio < 0.0) {
				throw new ArgumentOutOfRangeException("zoomRatio");
			}
			if (pictureBox.Image != null) {
				int width = (int)Math.Ceiling(pictureBox.Image.Width * zoomRatio);
				int height = (int)Math.Ceiling(pictureBox.Image.Height * zoomRatio);
				pictureBox.SizeMode = PictureBoxSizeMode.StretchImage;
				pictureBox.Size = new Size(width, height);
			}
		}
	}
}
