using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

using SystemNeo.Reflection;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	/// Windows ̃fXNgbvi܂͂̎qvfjŏʂƂc[\\ TreeView łB
	/// </summary>
	public class ShellTreeView : TreeView
	{
		#region private fields
		private bool fileSystemOnly = true;
		private bool folderOnly = true;
		private TreeNodeIconSize iconSize = TreeNodeIconSize.Small;
		private Environment.SpecialFolder rootFolder = Environment.SpecialFolder.Desktop;
		#endregion

		// public vpeB //

		/// <summary>
		/// t@CVXẽIuWFNg\邩ǂ܂B
		/// </summary>
		[DefaultValue(true)]
		public bool FileSystemOnly
		{
			get {
				return this.fileSystemOnly;
			}
			set {
				this.fileSystemOnly = value;
			}
		}

		/// <summary>
		/// tH_\邩ǂ܂B
		/// </summary>
		[DefaultValue(true)]
		public bool FolderOnly
		{
			get {
				return this.folderOnly;
			}
			set {
				this.folderOnly = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(TreeNodeIconSize.Small)]
		public TreeNodeIconSize IconSize
		{
			get {
				return this.iconSize;
			}
			set {
				this.iconSize = value;
			}
		}

		/// <summary>
		/// c[̍ŏʂɂtH_擾Eݒ肵܂B
		/// </summary>
		[DefaultValue(Environment.SpecialFolder.Desktop)]
		public Environment.SpecialFolder RootFolder
		{
			get {
				return this.rootFolder;
			}
			set {
				this.rootFolder = value;
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		public void Initialize()
		{
			this.BeginUpdate();
			try {
				this.RecreateRootNode();
			} finally {
				this.EndUpdate();
			}
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="e"></param>
		protected override void OnBeforeExpand(TreeViewCancelEventArgs e)
		{
			base.OnBeforeExpand(e);
			if (e.Node.Nodes.Count == 0) {
				using (new WaitCursor()) {
					this.BeginUpdate();
					try {
						IShellFolder shFolder;
						GetShellFolder((TreeNode)e.Node, out shFolder);
						this.EnumSubFolders((TreeNode)e.Node, shFolder);
						if (e.Node.Nodes.Count == 0) {
							TreeViewUtil.SetPlusVisible(e.Node, false);
						}
					} finally {
						this.EndUpdate();
					}
				}
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		private static unsafe Pidl GetFullItemIDList(TreeNode node)
		{
			if (node == null) {
				return null;
			}
			int totalSize = sizeof(ushort);
			TreeNode aNode = node;
			int level = TreeViewUtil.GetNodeLevel(node);
			var nodes = new TreeNode[level + 1];
			int i = 0;
			do {
				totalSize += aNode.pidl.GetSize() - sizeof(ushort);
				nodes[i++] = aNode;
				aNode = (TreeNode)aNode.Parent;
			} while (aNode != null);

			IntPtr result = Memory.AllocateInternal(totalSize);
			byte* p = (byte*)result;
			for (int j = level; j >= 0; j--) {
				int size = nodes[j].pidl.GetSize() - sizeof(ushort);
				NativeMethods.CopyMemory(p, nodes[j].pidl.ToIntPtr(), size);
				p += size;
			}
			NativeMethods.ZeroMemory(p, sizeof(ushort));
			return new Pidl(result);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="iconSize"></param>
		/// <returns></returns>
		private static SHGetFileInfoFlags GetIconSizeFlag(TreeNodeIconSize iconSize)
		{
			SHGetFileInfoFlags flags;
			switch (iconSize) {
			case TreeNodeIconSize.Large:
				flags = SHGetFileInfoFlags.SHGFI_LARGEICON;
				break;
			case TreeNodeIconSize.Small:
				flags = SHGetFileInfoFlags.SHGFI_SMALLICON;
				break;
			case TreeNodeIconSize.ShellSize:
				flags = SHGetFileInfoFlags.SHGFI_SHELLICONSIZE;
				break;
			default:
				throw new ArgumentException();
			}
			return flags;
		}

		/// <summary>
		/// w̃c[m[hɑΉ IShellFolder 擾܂B
		/// </summary>
		/// <param name='node'></param>
		/// <param name='shFolder'></param>
		/// <returns></returns>
		private static unsafe void GetShellFolder(TreeNode node, out IShellFolder shFolder)
		{
			using (Pidl pidl = GetFullItemIDList(node)) {
				if (pidl.IsDesktop()) {
					shFolder = Pidl.DesktopFolder;
				} else {
					var guid = new Guid(Guids.IShellFolder);
					Pidl.DesktopFolder.BindToObject(pidl.ToIntPtr(), IntPtr.Zero, ref guid, out shFolder);
				}
			}
		}

		/// <summary>
		/// VXẽC[WXgACR擾Ac[m[hɐݒ肵܂B
		/// </summary>
		/// <param name='node'></param>
		/// <returns></returns>
		private static IntPtr SetNodeImage(TreeNode node, TreeNodeIconSize iconSize)
		{
			using (Pidl pidl = GetFullItemIDList(node)) {
				SHGetFileInfoFlags flags = GetIconSizeFlag(iconSize);
				IntPtr sysImageListHandle;
				int imageIndex;
				pidl.GetIcon(false, flags, out sysImageListHandle, out imageIndex);
				node.ImageIndex = imageIndex;
				pidl.GetIcon(true, flags, out sysImageListHandle, out imageIndex);
				node.SelectedImageIndex = imageIndex;
				return sysImageListHandle;
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attributes"></param>
		/// <returns></returns>
		private bool CanAdd(ShellFolderContentAttributes attributes)
		{
			if (this.fileSystemOnly) {
				if (((attributes & ShellFolderContentAttributes.SFGAO_FILESYSTEM) == 0) &&
					( attributes & ShellFolderContentAttributes.SFGAO_FILESYSANCESTOR) == 0) {
					return false;
				}
			}
			return true;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="attributes"></param>
		/// <returns></returns>
		private bool PlusVisible(ShellFolderContentAttributes attributes)
		{
			if ((attributes & ShellFolderContentAttributes.SFGAO_FOLDER) == 0) {
				return false;
			}
			if ((attributes & ShellFolderContentAttributes.SFGAO_HASSUBFOLDER) != 0) {
				return true;
			}
			return ! this.folderOnly;
		}

		/// <summary>
		/// tH_̎qvf񋓂AꂼɑΉc[m[h쐬܂B
		/// </summary>
		/// <param name='node'></param>
		/// <param name='shFolder'></param>
		private void EnumSubFolders(TreeNode node, IShellFolder shFolder)
		{
			if (shFolder == null) {
				return;
			}
			ShellFolderContentFlags shcontf = ShellFolderContentFlags.SHCONTF_FOLDERS;
			if (! this.folderOnly) {
				shcontf |= ShellFolderContentFlags.SHCONTF_NONFOLDERS;
			}
			IEnumIDList eid;
			var pidls = new IntPtr[32];
			int fetched;
			shFolder.EnumObjects(this.Handle, shcontf, out eid);
			if (eid != null) {
				var nodeList = new ArrayList();
				for (;;) {
					HRESULT hres = eid.Next(pidls.Length, pidls, out fetched);
					switch (hres) {
					case HRESULT.NOERROR:
					case HRESULT.S_FALSE:
						break;
					default:
						Marshal.ThrowExceptionForHR((int)hres);
						return;
					}
					if (hres == HRESULT.S_FALSE) {
						break;
					}
					for (int i = 0; i < fetched; i++) {
						var subNode = new TreeNode(shFolder, new Pidl(pidls[i]));
						subNode.ToolTipText = subNode.Path;
						if (this.CanAdd(subNode.Attributes)) {
							nodeList.Add(subNode);
						}
					}
				}
				nodeList.Sort(TreeNodeComparer.instance);
				foreach (TreeNode subNode in nodeList) {
					node.Nodes.Add(subNode);
					SetNodeImage(subNode, this.iconSize);
					if (this.PlusVisible(subNode.Attributes)) {
						TreeViewUtil.SetPlusVisible(subNode, true);
					}
				}
			}
		}

		/// <summary>
		/// [gm[hēx쐬܂B
		/// </summary>
		private void RecreateRootNode()
		{
			Pidl pidl = Pidl.GetSpecialFolder(this.rootFolder, this.Handle);
			var rootNode = new TreeNode(Pidl.DesktopFolder, pidl);
			rootNode.ToolTipText = pidl.GetPath();
			IntPtr sysImageListHandle = SetNodeImage(rootNode, this.iconSize);
			TreeViewUtil.SetImageList(this, sysImageListHandle);
			this.BeginUpdate();
			try {
				this.Nodes.Clear();
				this.Nodes.Add(rootNode);
				TreeViewUtil.SetPlusVisible(rootNode, true);
			} finally {
				this.EndUpdate();
			}
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public enum TreeNodeIconSize : uint
		{
			Large,
			Small,
			ShellSize
		}

		/// <summary>
		/// ShellTreeView ɂc[m[h\܂B
		/// </summary>
		[ComVisible(false)]
		public sealed class TreeNode : System.Windows.Forms.TreeNode, IDisposable
		{
			#region internal fields
			internal readonly Pidl pidl;
			#endregion

			// public vpeB //

			/// <summary>
			/// m[ht@CVXẽfBNgƑΉĂꍇɁÃtpX擾܂B
			/// </summary>
			public string Path { get; private set; }

			// internal vpeB //

			/// <summary>
			/// 
			/// </summary>
			internal ShellFolderContentAttributes Attributes { get; private set; }

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="shFolder"></param>
			/// <param name="pidl"></param>
			internal TreeNode(IShellFolder shFolder, Pidl pidl) : base()
			{
				this.pidl = pidl;
				this.Path = pidl.GetDisplayName(shFolder, ShellFolderDisplayNameFlags.SHGDN_FORPARSING);
				this.Text = pidl.GetDisplayName(shFolder, ShellFolderDisplayNameFlags.SHGDN_INFOLDER);
				try {
					this.Attributes = pidl.GetAttributes(shFolder);
				} catch (COMException ex) {
					Debug.WriteLine(ex.ToString());
				}
			}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			void IDisposable.Dispose()
			{
				this.pidl.Dispose();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private sealed class TreeNodeComparer : IComparer
		{
			#region internal static fields
			internal static readonly TreeNodeComparer instance = new TreeNodeComparer();
			#endregion

			// private RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			private TreeNodeComparer() {}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="x"></param>
			/// <param name="y"></param>
			/// <returns></returns>
			int IComparer.Compare(object x, object y)
			{
				var nx = (TreeNode)x;
				var ny = (TreeNode)y;
				bool xIsFolder = (nx.Attributes & ShellFolderContentAttributes.SFGAO_FOLDER) != 0;
				bool yIsFolder = (ny.Attributes & ShellFolderContentAttributes.SFGAO_FOLDER) != 0;
				if (xIsFolder == yIsFolder) {
					int cmp = string.Compare(nx.Path, ny.Path);
					if (cmp == 0) {
						cmp = string.Compare(nx.Text, ny.Text);
					}
					return cmp;
				} else {
					return (xIsFolder ? -1 : 1);
				}
			}
		}
	}
}
