using System;
using System.Collections;
using System.Collections.Generic;
using System.Windows.Forms;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Windows.Forms
{
	/// <summary>
	///
	/// </summary>
	public class TreeViewTreeManager : TreeManager
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public static readonly TreeViewTreeManager Default = new TreeViewTreeManager();

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		public override void AddChild(object parent, object child)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(TreeView), typeof(TreeNode));
			ArgumentUtil.AssertType(child, "child", typeof(TreeNode));
			TreeNodeCollection nodes;
			if (parent is TreeView) {
				nodes = ((TreeView)parent).Nodes;
			} else {
				nodes = ((TreeNode)parent).Nodes;
			}
			nodes.Add((TreeNode)child);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public TreeNode FindFirst(TreeView treeView, Func<TreeNode, bool> match)
		{
			return this.FindFirst(treeView, match, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="match"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public TreeNode FindFirst(TreeView treeView, Func<TreeNode, bool> match, int depth)
		{
			return this.FindFirst(treeView, match, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public TreeNode FindFirst(TreeView treeView,
				Func<TreeNode, bool> match, TreeSearchAlgorithm algorithm, int depth)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			return base.FindFirst<TreeNode>(treeView, match, algorithm, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <returns></returns>
		public TreeNode FindFirst(TreeNode baseNode, Func<TreeNode, bool> match)
		{
			return base.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public TreeNode FindFirst(TreeNode baseNode, Func<TreeNode, bool> match, int depth)
		{
			return base.FindFirst(baseNode, match, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="match"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		/// <returns></returns>
		public TreeNode FindFirst(TreeNode baseNode,
				Func<TreeNode, bool> match, TreeSearchAlgorithm algorithm, int depth)
		{
			return base.FindFirst(baseNode, match, algorithm, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public TreeNode FindNext(TreeNode currentNode, Func<TreeNode, bool> match, bool loop)
		{
			return base.FindNext(currentNode, match, loop);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="currentNode"></param>
		/// <param name="match"></param>
		/// <param name="loop"></param>
		/// <returns></returns>
		public TreeNode FindPrevious(TreeNode currentNode, Func<TreeNode, bool> match, bool loop)
		{
			return base.FindPrevious(currentNode, match, loop);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="action"></param>
		public void ForEach(TreeView treeView, Action<TreeNode> action)
		{
			base.ForEach(treeView, action, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="action"></param>
		/// <param name="depth"></param>
		public void ForEach(TreeView treeView, Action<TreeNode> action, int depth)
		{
			base.ForEach(treeView, action, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="action"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		public void ForEach(TreeView treeView,
				Action<TreeNode> action, TreeSearchAlgorithm algorithm, int depth)
		{
			base.ForEach(treeView, action, algorithm, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		public void ForEach(TreeNode baseNode, Action<TreeNode> action)
		{
			base.ForEach(baseNode, action, TreeSearchAlgorithm.Default, DepthInfinity);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="depth"></param>
		public void ForEach(TreeNode baseNode, Action<TreeNode> action, int depth)
		{
			base.ForEach(baseNode, action, TreeSearchAlgorithm.Default, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="baseNode"></param>
		/// <param name="action"></param>
		/// <param name="algorithm"></param>
		/// <param name="depth"></param>
		public void ForEach(TreeNode baseNode,
				Action<TreeNode> action, TreeSearchAlgorithm algorithm, int depth)
		{
			base.ForEach(baseNode, action, algorithm, depth);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override IEnumerable GetChildren(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(TreeView), typeof(TreeNode));
			if (node is TreeView) {
				return ((TreeView)node).Nodes;
			} else {
				return ((TreeNode)node).Nodes;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override object GetNextSibling(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(TreeView), typeof(TreeNode));
			if (node is TreeView) {
				return null;
			} else {
				return ((TreeNode)node).NextNode;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override object GetParent(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(TreeView), typeof(TreeNode));
			if (node is TreeView) {
				return null;
			} else {
				return ((TreeNode)node).Parent;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <returns></returns>
		public override object GetPreviousSibling(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(TreeView), typeof(TreeNode));
			if (node is TreeView) {
				return null;
			} else {
				return ((TreeNode)node).PrevNode;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="index"></param>
		public override void Insert(object parent, object child, int index)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(TreeView), typeof(TreeNode));
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(child, "child", typeof(TreeNode));
			if (index < 0) {
				throw new ArgumentOutOfRangeException("index");
			}
			TreeNodeCollection nodes;
			if (parent is TreeView) {
				nodes = ((TreeView)parent).Nodes;
			} else {
				nodes = ((TreeNode)parent).Nodes;
			}
			if (index < nodes.Count) {
				nodes.Insert(index, (TreeNode)child);
			} else {
				nodes.Add((TreeNode)child);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="child"></param>
		/// <param name="comparer"></param>
		public void InsertSorted(TreeView treeView, TreeNode child, IComparer<TreeNode> comparer)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			base.InsertSorted(treeView, child, comparer);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparer"></param>
		public void InsertSorted(TreeNode parent, TreeNode child, IComparer<TreeNode> comparer)
		{
			base.InsertSorted(parent, child, comparer);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="child"></param>
		/// <param name="comparison"></param>
		public void InsertSorted(TreeView treeView, TreeNode child, Comparison<TreeNode> comparison)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			base.InsertSorted(treeView, child, comparison);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		/// <param name="comparison"></param>
		public void InsertSorted(TreeNode parent, TreeNode child, Comparison<TreeNode> comparison)
		{
			base.InsertSorted(parent, child, comparison);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		public override void RemoveAllChildren(object node)
		{
			ArgumentUtil.AssertNull(node, "node");
			ArgumentUtil.AssertType(node, "node", typeof(TreeView), typeof(TreeNode));
			if (node is TreeView) {
				((TreeView)node).Nodes.Clear();
			} else {
				((TreeNode)node).Nodes.Clear();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="parentNode"></param>
		/// <param name="child"></param>
		public override void RemoveChild(object parent, object child)
		{
			ArgumentUtil.AssertNull(parent, "parentNode");
			ArgumentUtil.AssertType(parent, "parentNode", typeof(TreeView), typeof(TreeNode));
			ArgumentUtil.AssertNull(child, "child");
			ArgumentUtil.AssertType(child, "child", typeof(TreeNode));
			TreeNodeCollection nodes;
			if (parent is TreeView) {
				nodes = ((TreeView)parent).Nodes;
			} else {
				nodes = ((TreeNode)parent).Nodes;
			}
			nodes.Remove((TreeNode)child);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="comparer"></param>
		/// <param name="recurse"></param>
		public void Sort(TreeView treeView, IComparer<TreeNode> comparer, bool recurse)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			base.Sort(treeView, comparer, recurse);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparer"></param>
		/// <param name="recurse"></param>
		public void Sort(TreeNode node, IComparer<TreeNode> comparer, bool recurse)
		{
			base.Sort<TreeNode>(node, comparer, recurse);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="treeView"></param>
		/// <param name="comparison"></param>
		/// <param name="recurse"></param>
		public void Sort(TreeView treeView, Comparison<TreeNode> comparison, bool recurse)
		{
			ArgumentUtil.AssertNull(treeView, "treeView");
			base.Sort(treeView, comparison, recurse);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="node"></param>
		/// <param name="comparison"></param>
		/// <param name="recurse"></param>
		public void Sort(TreeNode node, Comparison<TreeNode> comparison, bool recurse)
		{
			base.Sort(node, comparison, recurse);
		}
	}
}
