using System;
using System.Runtime.InteropServices;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	[ComImport][Guid(Guids.IShellFolder)]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	internal interface IShellFolder
	{
		/// <summary>
		/// 
		/// </summary>
		/// <param name="hwndOwner"></param>
		/// <param name="pbcReserved"></param>
		/// <param name="lpszDisplayName"></param>
		/// <param name="pchEaten"></param>
		/// <param name="ppidl"></param>
		/// <param name="pdwAttributes"></param>
		void ParseDisplayName(IntPtr hwndOwner, IntPtr pbcReserved,
				[MarshalAs(UnmanagedType.LPWStr)] string lpszDisplayName,
				out uint pchEaten, out IntPtr ppidl, ref ShellFolderContentAttributes pdwAttributes);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hwndOwner"></param>
		/// <param name="grfFlags"></param>
		/// <param name="ppenumIDList"></param>
		void EnumObjects(IntPtr hwndOwner,
				ShellFolderContentFlags grfFlags, out IEnumIDList ppenumIDList);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pidl"></param>
		/// <param name="pbcReserved"></param>
		/// <param name="riid"></param>
		/// <param name="ppvOut"></param>
		void BindToObject(IntPtr pidl, IntPtr pbcReserved, ref Guid riid, out IShellFolder ppvOut);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pidl"></param>
		/// <param name="pbcReserved"></param>
		/// <param name="riid"></param>
		/// <param name="ppvObj"></param>
		void BindToStorage(IntPtr pidl, IntPtr pbcReserved, ref Guid riid, IntPtr ppvObj);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lParam"></param>
		/// <param name="pidl1"></param>
		/// <param name="pidl2"></param>
		/// <returns></returns>
		[PreserveSig]
		HRESULT CompareIDs(IntPtr lParam, IntPtr pidl1, IntPtr pidl2);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hwndOwner"></param>
		/// <param name="riid"></param>
		/// <param name="ppvOut"></param>
		void CreateViewObject(IntPtr hwndOwner, ref Guid riid, IntPtr ppvOut);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="cidl"></param>
		/// <param name="apidl"></param>
		/// <param name="rgfInOut"></param>
		void GetAttributesOf(int cidl,
				[MarshalAs(UnmanagedType.LPArray)] IntPtr[] apidl,
				ref ShellFolderContentAttributes rgfInOut);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hwndOwner"></param>
		/// <param name="cidl"></param>
		/// <param name="apidl"></param>
		/// <param name="riid"></param>
		/// <param name="prgfInOut"></param>
		/// <param name="ppvOut"></param>
		void GetUIObjectOf(IntPtr hwndOwner,
				int cidl, ref IntPtr apidl, ref Guid riid, out int prgfInOut, ref IUnknown ppvOut);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pidl"></param>
		/// <param name="uFlags"></param>
		/// <param name="lpName"></param>
		void GetDisplayNameOf(IntPtr pidl, ShellFolderDisplayNameFlags uFlags, ref STRRET_CSTR lpName);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="hwndOwner"></param>
		/// <param name="pidl"></param>
		/// <param name="lpszName"></param>
		/// <param name="uFlags"></param>
		/// <param name="ppidlOut"></param>
		void SetNameOf(IntPtr hwndOwner, IntPtr pidl,
				[MarshalAs(UnmanagedType.LPWStr)] string lpszName,
				ShellFolderDisplayNameFlags uFlags, ref IntPtr ppidlOut);
	}
}
