using System;
using System.Runtime.InteropServices;
using System.Text;

using SystemNeo;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	internal class Pidl : Memory
	{
		// internal static tB[h //

		/// <summary>
		/// 
		/// </summary>
		internal static readonly IShellFolder DesktopFolder;

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static Pidl()
		{
			DesktopFolder = NativeMethods.SHGetDesktopFolder();
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pidl"></param>
		internal Pidl(IntPtr pidl) : base(pidl) {}

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pidl1"></param>
		/// <param name="pidl2"></param>
		/// <returns></returns>
		internal unsafe static Pidl Concat(Pidl pidl1, Pidl pidl2)
		{
			ArgumentUtil.AssertNull(pidl1, "pidl1");
			ArgumentUtil.AssertNull(pidl2, "pidl2");
			int size1 = pidl1.GetSize() - sizeof(ushort);
			int size2 = pidl2.GetSize();
			IntPtr memory = AllocateInternal(size1 + size2);
			byte* p = (byte*)memory;
			NativeMethods.CopyMemory(p, pidl1.ToIntPtr(), size1);
			NativeMethods.CopyMemory(p + size1, pidl2.ToIntPtr(), size2);
			return new Pidl(memory);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="folder"></param>
		/// <returns></returns>
		internal static Pidl GetSpecialFolder(Environment.SpecialFolder folder)
		{
			return GetSpecialFolder(folder, IntPtr.Zero);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="folder"></param>
		/// <param name="hwnd"></param>
		/// <returns></returns>
		internal static Pidl GetSpecialFolder(Environment.SpecialFolder folder, IntPtr hwnd)
		{
			IntPtr pidl = NativeMethods.SHGetSpecialFolderLocation(hwnd, folder);
			return new Pidl(pidl);
		}

		// internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="shFolder"></param>
		/// <returns></returns>
		internal ShellFolderContentAttributes GetAttributes(IShellFolder shFolder)
		{
			ArgumentUtil.AssertNull(shFolder, "shFolder");
			IntPtr[] apidl = {this.ToIntPtr()};
			var attr = (ShellFolderContentAttributes)uint.MaxValue;
			shFolder.GetAttributesOf(apidl.Length, apidl, ref attr);
			return attr;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="shFolder"></param>
		/// <param name="flags"></param>
		/// <returns></returns>
		internal string GetDisplayName(IShellFolder shFolder, ShellFolderDisplayNameFlags flags)
		{
			ArgumentUtil.AssertNull(shFolder, "shFolder");
			var strret = new STRRET_CSTR();
			shFolder.GetDisplayNameOf(this.ToIntPtr(), flags, ref strret);
			switch (strret.uType) {
			case StrRetType.STRRET_WSTR:
				string name;
				unsafe {
					fixed (byte* pb = strret.cStr) {
						char** ppc = (char**)pb;
						name = new string(*ppc);
						Free(new IntPtr(*ppc));
					}
				}
				return name;
			case StrRetType.STRRET_CSTR:
				int zeroPos = Array.IndexOf(strret.cStr, new byte());
				int length = (zeroPos >= 0 ? zeroPos : strret.cStr.Length);
				return new string(Encoding.Default.GetChars(strret.cStr, 0, length));
			default:
				throw new NotSupportedException();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="openIcon"></param>
		/// <param name="flags"></param>
		/// <param name="sysImageListHandle"></param>
		/// <param name="sysImageListIndex"></param>
		internal void GetIcon(bool openIcon,
				SHGetFileInfoFlags flags, out IntPtr sysImageListHandle, out int sysImageListIndex)
		{
			flags |= SHGetFileInfoFlags.SHGFI_PIDL;
			flags |= SHGetFileInfoFlags.SHGFI_ICON | SHGetFileInfoFlags.SHGFI_SYSICONINDEX;
			if (openIcon) {
				flags |= SHGetFileInfoFlags.SHGFI_OPENICON;
			}
			var sfi = new SHFILEINFO();
			sysImageListHandle = NativeMethods.SHGetFileInfo(this.ToIntPtr(), 0, ref sfi, flags);
			NativeMethods.DestroyIcon(sfi.hIcon);
			sysImageListIndex = sfi.iIcon;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		internal string GetPath()
		{
			return NativeMethods.SHGetPathFromIDList(this.ToIntPtr());
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		internal unsafe bool IsDesktop()
		{
			return this.GetSize() == sizeof(ushort);
		}
	}
}
