using System;
using System.ComponentModel;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	public class Stopwatch
	{
		#region private fields
		private long count;
		private double frequency;
		private long start;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public double LapTime
		{
			get {
				return this.TotalTime / this.count;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public TimeSpan LapTimeSpan
		{
			get {
				return new TimeSpan((long)this.LapTime);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public double TotalTime { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public TimeSpan TotalTimeSpan
		{
			get {
				return new TimeSpan((long)this.TotalTime);
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public Stopwatch() : this(false) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="start"></param>
		public Stopwatch(bool start)
		{
			long l;
			if (! NativeMethods.QueryPerformanceFrequency(out l)) {
				throw new Win32Exception();
			}
			this.frequency = (double)l / TimeSpan.TicksPerSecond;
			if (start) {
				this.Start();
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		public void Reset()
		{
			this.TotalTime = 0;
			this.count = 0;
		}

		/// <summary>
		/// 
		/// </summary>
		public void Start()
		{
			if (! NativeMethods.QueryPerformanceCounter(out this.start)) {
				throw new Win32Exception();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns>JňoߎԂ\^C}ݐB</returns>
		public double Stop()
		{
			long stop;
			if (! NativeMethods.QueryPerformanceCounter(out stop)) {
				throw new Win32Exception();
			}
			long passed = stop - this.start;
			if (passed < 0) {
				throw new InvalidOperationException();
			}
			double result = passed / this.frequency;
			this.TotalTime += result;
			this.count++;
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="milliseconds"></param>
		public void Stop(out double milliseconds)
		{
			milliseconds = this.Stop() / TimeSpan.TicksPerMillisecond;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="time"></param>
		public void Stop(out TimeSpan time)
		{
			time = new TimeSpan((long)this.Stop());
		}
	}
}
