using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
	internal struct TVITEM
	{
		#region private fields
		private readonly TreeViewItemMask mask;
		private readonly IntPtr hItem;
		private readonly TreeViewItemStates state;
		private readonly TreeViewItemStates stateMask;
		[MarshalAs(UnmanagedType.LPTStr)]
		private readonly string pszText;
		private readonly int cchTextMax;
		private readonly int iImage;
		private readonly int iSelectedImage;
		private readonly TreeViewItemChildren cChildren;
		private readonly IntPtr lParam;
		#endregion

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="mask"></param>
		/// <param name="node"></param>
		/// <param name="children"></param>
		internal TVITEM(TreeViewItemMask mask, TreeNode node, TreeViewItemChildren children)
		{
			this.mask = mask;
			this.hItem = node.Handle;
			this.state = 0;
			this.stateMask = 0;
			this.pszText = null;
			this.cchTextMax = 0;
			this.iImage = 0;
			this.iSelectedImage = 0;
			this.cChildren = children;
			this.lParam = IntPtr.Zero;
		}
	}
}
