using System;
using System.IO;

namespace SystemNeo.Windows
{
	/// <summary>
	/// 
	/// </summary>
	internal enum AppBarEdge : uint
	{
		ABE_LEFT = 0,
		ABE_TOP,
		ABE_RIGHT,
		ABE_BOTTOM
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum AppBarMessage : uint
	{
		ABM_NEW = 0,
		ABM_REMOVE,
		ABM_QUERYPOS,
		ABM_SETPOS,
		ABM_GETSTATE,
		ABM_GETTASKBARPOS,
		ABM_ACTIVATE,
		ABM_GETAUTOHIDEBAR,
		ABM_SETAUTOHIDEBAR,
		ABM_WINDOWPOSCHANGED,
		ABM_SETSTATE
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum AppBarNotification : uint
	{
		ABN_STATECHANGE = 0,
		ABN_POSCHANGED,
		ABN_FULLSCREENAPP,
		ABN_WINDOWARRANGE
	}

	/// <summary>
	/// 
	/// </summary>
	[Flags]
	internal enum FileFlagsAndAttributes : uint
	{
		FILE_ATTRIBUTE_READONLY   = FileAttributes.ReadOnly,
		FILE_ATTRIBUTE_HIDDEN     = FileAttributes.Hidden,
		FILE_ATTRIBUTE_SYSTEM     = FileAttributes.System,
		FILE_ATTRIBUTE_DIRECTORY  = FileAttributes.Directory,
		FILE_ATTRIBUTE_ARCHIVE    = FileAttributes.Archive,
		FILE_ATTRIBUTE_NORMAL     = FileAttributes.Normal,
		FILE_ATTRIBUTE_TEMPORARY  = FileAttributes.Temporary,
		FILE_ATTRIBUTE_COMPRESSED = FileAttributes.Compressed,
		FILE_ATTRIBUTE_OFFLINE    = FileAttributes.Offline,
		FILE_FLAG_DELETE_ON_CLOSE = FileOptions.DeleteOnClose
	}

	/// <summary>
	/// 
	/// </summary>
	[Flags]
	internal enum FileSecurityAndGenericRights : uint
	{
		GENERIC_READ    = 0x80000000,
		GENERIC_WRITE   = 0x40000000,
		GENERIC_EXECUTE = 0x20000000,
		GENERIC_ALL     = 0x10000000
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum HRESULT : int
	{
		S_OK = 0,
		S_FALSE = 1,
		NOERROR = 0
	}

	/// <summary>
	/// IShellFolder::GetAttributesOf() ŃIuWFNg̑̂Ɏgp񋓑̂łB
	/// </summary>
	[Flags]
	internal enum ShellFolderContentAttributes : uint
	{
		SFGAO_CANCOPY         = 0x0001,
		SFGAO_CANMOVE         = 0x0002,
		SFGAO_CANLINK         = 0x0004,
		SFGAO_CANRENAME       = 0x0010,
		SFGAO_CANDELETE       = 0x0020,
		SFGAO_HASPROPSHEET    = 0x0040,
		SFGAO_DROPTARGET      = 0x0100,
		SFGAO_CAPABILITYMASK  = 0x0177,
		SFGAO_LINK            = 0x00010000,
		SFGAO_SHARE           = 0x00020000,
		SFGAO_READONLY        = 0x00040000,
		SFGAO_GHOSTED         = 0x00080000,
		SFGAO_DISPLAYATTRMASK = 0x000F0000,
		SFGAO_VALIDATE        = 0x01000000,
		SFGAO_REMOVABLE       = 0x02000000,
		SFGAO_COMPRESSED      = 0x04000000,
		SFGAO_FILESYSANCESTOR = 0x10000000,
		SFGAO_FOLDER          = 0x20000000,
		SFGAO_FILESYSTEM      = 0x40000000,
		SFGAO_HASSUBFOLDER    = 0x80000000,
		SFGAO_CONTENTSMASK    = 0x80000000
	}

	/// <summary>
	/// IShellFolder::EnumObjects() Ŏgp񋓑̂łB
	/// tH_̓eƂė񋓂IuWFNg̎ނ\܂B
	/// </summary>
	[Flags]
	internal enum ShellFolderContentFlags : uint
	{
		/// <summary>tH_\܂B</summary>
		SHCONTF_FOLDERS = 0x0020,
		/// <summary>tH_ȊO\܂B</summary>
		SHCONTF_NONFOLDERS = 0x0040,
		/// <summary>BIuWFNg\܂B</summary>
		SHCONTF_INCLUDEHIDDEN = 0x0080
	}

	/// <summary>
	/// IShellFolder::GetDisplayNameOf() Ŏgp񋓑̂łB
	/// </summary>
	[Flags]
	internal enum ShellFolderDisplayNameFlags : uint
	{
		SHGDN_NORMAL        = 0x0000,
		SHGDN_INFOLDER      = 0x0001,
		SHGDN_FORADDRESSBAR = 0x4000,
		SHGDN_FORPARSING    = 0x8000
	}

	/// <summary>
	/// 
	/// </summary>
	[Flags]
	public enum SHFileOperationFlags : ushort
	{
		/// <summary>ΏۂꍇɁÃpXʂɎw肵܂B</summary>
		FOF_MULTIDESTFILES = 0x0001,
		FOF_CONFIRMMOUSE = 0x0002,
		/// <summary>ro߂_CAO{bNX\܂B</summary>
		FOF_SILENT = 0x0004,
		/// <summary>t@CdꍇAIɐVOt܂B</summary>
		FOF_RENAMEONCOLLISION = 0x0008,
		/// <summary>̓rŊmF̃_CAO{bNX\܂B</summary>
		FOF_NOCONFIRMATION = 0x0010,
		FOF_WANTMAPPINGHANDLE = 0x0020,
		/// <summary>AhDs悤ɂ܂B</summary>
		FOF_ALLOWUNDO = 0x0040,
		FOF_FILESONLY = 0x0080,
		/// <summary>ro߂_CAO{bNXɃt@C\܂B</summary>
		FOF_SIMPLEPROGRESS = 0x0100,
		/// <summary>IɐVfBNg쐬܂B</summary>
		FOF_NOCONFIRMMKDIR = 0x0200,
		FOF_NOERRORUI = 0x0400,
		FOF_NOCOPYSECURITYATTRIBS = 0x0800,
		/// <summary>TufBNg𑀍ΏۂɊ܂߂܂B</summary>
		FOF_NORECURSION = 0x1000,
		FOF_NO_CONNECTED_ELEMENTS = 0x2000,
		FOF_WANTNUKEWARNING = 0x4000,
		FOF_NORECURSEREPARSE = 0x8000
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum SHFileOperationFunc : uint
	{
		FO_MOVE = 1,
		FO_COPY = 2,
		FO_DELETE = 3,
		FO_RENAME = 4
	}

	/// <summary>
	/// 
	/// </summary>
	[Flags]
	internal enum SHGetFileInfoFlags : uint
	{
		SHGFI_ICON              = 0x0100,
		SHGFI_ICONLOCATION      = 0x1000,
		SHGFI_SYSICONINDEX      = 0x4000,
		SHGFI_LARGEICON         = 0x0000,
		SHGFI_SMALLICON         = 0x0001,
		SHGFI_OPENICON          = 0x0002,
		SHGFI_SHELLICONSIZE     = 0x0004,
		SHGFI_PIDL              = 0x0008,
		SHGFI_USEFILEATTRIBUTES = 0x0010
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum StrRetType : uint
	{
		STRRET_WSTR = 0,
		STRRET_OFFSET = 1,
		STRRET_CSTR = 2
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum TreeViewGetNextKind : int
	{
		TVGN_ROOT = 0,
		TVGN_PARENT = 3,
		TVGN_CHILD = 4,
		TVGN_DROPHILITE = 8,
		TVGN_CARET = 10
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum TreeViewItemChildren : int
	{
		Zero = 0,
		NonZero = 1,
		Auto = -1
	}

	/// <summary>
	/// 
	/// </summary>
	[Flags]
	internal enum TreeViewItemMask : uint
	{
		TVIF_TEXT          = 0x0001,
		TVIF_IMAGE         = 0x0002,
		TVIF_SELECTEDIMAGE = 0x0020,
		TVIF_CHILDREN      = 0x0040
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum TreeViewImageList : uint
	{
		TVSIL_NORMAL = 0,
		TVSIL_STATE = 2
	}

	/// <summary>
	/// 
	/// </summary>
	[Flags]
	internal enum TreeViewItemStates : uint
	{
		TVIS_FOCUSED       = 0x0001,
		TVIS_EXPANDPARTIAL = 0x0080
	}

	/// <summary>
	/// 
	/// </summary>
	internal enum TreeViewMessage : uint
	{
		TV_FIRST = 0x1100,
		TVM_SETIMAGELIST = TV_FIRST +  9,
		TVM_SELECTITEM   = TV_FIRST + 11,
		TVM_SETITEMA     = TV_FIRST + 13,
		TVM_SETITEMW     = TV_FIRST + 63
	}

	/// <summary>
	/// 
	/// </summary>
	[Flags]
	internal enum WindowExStyles : uint
	{
		WS_EX_TOOLWINDOW = 0x00000080
	}
}
