﻿using System;
using System.Xml;

namespace SystemNeo.Xml.Xindice
{
	/// <summary>
	/// 
	/// </summary>
	public class XindiceCollection
	{
		// public プロパティ //

		/// <summary>
		/// 
		/// </summary>
		public string Path { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public XindiceClient XindiceClient { get; private set; }

		// internal コンストラクタ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="client"></param>
		/// <param name="path"></param>
		internal XindiceCollection(XindiceClient client, string path)
		{
			this.XindiceClient = client;
			this.Path = path;
			this.GetMetadata();
		}

		// public メソッド //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public string[] GetDocumentNames()
		{
			return this.XindiceClient.GetDocumentNames(this.Path);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public XmlDocument GetMetadata()
		{
			return this.XindiceClient.GetCollectionMetadata(this.Path);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="xpath"></param>
		/// <returns></returns>
		public XmlDocument Query(string xpath)
		{
			return this.XindiceClient.Query(this.Path, xpath);
		}
	}
}
