using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;

using SystemNeo;

namespace SystemNeo.Cache
{
	/// <summary>
	/// <see cref="SystemNeo.Cache.ICache">ICache</see> C^[tF[XALbV@\񋟂܂B
	/// ͒ۃNXłB
	/// </summary>
	/// <typeparam name="TKey"></typeparam>
	/// <typeparam name="TEntry"></typeparam>
	public abstract class Cache<TKey, TEntry> : IDisposable, ICache<TKey, TEntry>
			where TEntry : CacheEntry<TKey, TEntry>
	{
		#region internal fields
		protected readonly IDictionary<TKey, TEntry> dic = new Dictionary<TKey, TEntry>();
		#endregion

		#region private fields
		private TimeSpan cleanInterval;
		private readonly Timer cleanTimer;
		private readonly TimeSpan lifeTime;
		#endregion

		// public Cxg //

		/// <summary>
		/// 
		/// </summary>
		public event CacheExceptionEventHandler<TKey, TEntry> Exception;

		// public vpeB //

		/// <summary>
		/// ێԂ߂Gg̍폜sԊu擾܂͐ݒ肵܂B
		/// </summary>
		public TimeSpan CleanInterval
		{
			get {
				return this.cleanInterval;
			}
			set {
				this.cleanTimer.Change(TimeSpan.Zero, value);
				this.cleanInterval = value;
			}
		}

		/// <summary>
		/// ێĂGg̐擾܂B
		/// </summary>
		public int EntryCount
		{
			get {
				return this.dic.Count;
			}
		}

		/// <summary>
		/// LbVqbg񐔂擾܂B
		/// </summary>
		public ulong HitCount { get; private set; }

		/// <summary>
		/// LbV̕ێԂ\܂B
		/// </summary>
		public TimeSpan LifeTime { get; set; }

		/// <summary>
		/// ێԂ߂ăLbV폜ꂽGg̐擾܂B
		/// </summary>
		public ulong RemoveCount { get; private set; }

		/// <summary>
		/// LbVIuWFNg擾ꂽ񐔂擾܂B
		/// ́ALbVqbg񐔂ƃ~X񐔂Ƃ̘ałB
		/// </summary>
		public ulong RequestCount { get; private set; }

		// protected RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="lifeTime">ێԁB</param>
		/// <param name="cleanInterval">ێԂ߂Gg̍폜sԊuB</param>
		protected Cache(TimeSpan lifeTime, TimeSpan cleanInterval)
		{
			this.lifeTime = lifeTime;
			this.cleanTimer = new Timer(this.CleanTimerCallback, null, 0, Timeout.Infinite);
			this.CleanInterval = cleanInterval;
		}

		// public \bh //

		/// <summary>
		/// LbṼGĝAێԂ߂̂폜܂B
		/// </summary>
		public void Clean()
		{
			var keyList = new List<TKey>();
			DateTime now = DateTime.Now;
			lock (this.dic) {
				foreach (var entry in this.dic.Values) {
					if (now - entry.lastAccess > this.lifeTime) {
						entry.state = CacheEntryState.Expired;
						keyList.Add(entry.Key);
						entry.Dispose();
					}
				}
				foreach (TKey key in keyList) {
					this.dic.Remove(key);
					this.RemoveCount++;
				}
			}
			Debug.WriteLine(string.Format(
					"{0:HH:mm:ss}  Cache::Clean  Count={1:N0}", DateTime.Now, keyList.Count));
		}

		/// <summary>
		/// 
		/// </summary>
		public void Dispose()
		{
			lock (this.dic) {
				foreach (var pair in this.dic) {
					pair.Value.Dispose();
				}
				this.dic.Clear();
			}
		}

		/// <summary>
		/// LbVIuWFNg擾܂B
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public TEntry Get(TKey key)
		{
			return this.GetInternal(key, null);
		}

		/// <summary>
		/// LbVIuWFNg擾܂B
		/// </summary>
		/// <param name="key"></param>
		/// <param name="invocation"></param>
		/// <returns></returns>
		public TEntry Get(TKey key, DelegateInvocation invocation)
		{
			if (invocation == null) {
				return this.GetInternal(key, null);
			} else {
				var ceei = new CacheEntryEventInvocation<TKey, TEntry>(invocation);
				return this.GetInternal(key, ceei.Invoke);
			}
		}

		/// <summary>
		/// LbVIuWFNg擾܂B
		/// </summary>
		/// <param name="key"></param>
		/// <param name="prepared"></param>
		/// <returns></returns>
		public TEntry Get(TKey key, CacheEntryEventHandler<TKey, TEntry> prepared)
		{
			return this.GetInternal(key, prepared);
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="cache"></param>
		/// <param name="key"></param>
		/// <param name="prepared"></param>
		/// <returns></returns>
		protected abstract TEntry CreateEntry(ICache<TKey, TEntry> cache,
				TKey key, CacheEntryEventHandler<TKey, TEntry> prepared);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="prepared"></param>
		/// <returns></returns>
		protected virtual TEntry GetInternal(
				TKey key, CacheEntryEventHandler<TKey, TEntry> prepared)
		{
			this.RequestCount++;
			TEntry entry;
			lock (this.dic) {
				try {
					entry = this.dic[key];
					this.HitCount++;
				} catch (KeyNotFoundException) {
					entry = this.CreateEntry(this, key, prepared);
					if (entry == null) {
						return null;
					}
					this.dic[key] = entry;
				}
			}
			entry.lastAccess = DateTime.Now;
			if (prepared != null) {
				if (entry.State == CacheEntryState.Preparing) {
					entry.Prepared += prepared;
				}
			}
			return entry;
		}

		// internal \bh //

		/// <summary>
		/// Exception CxgN܂B
		/// </summary>
		/// <param name="entry"></param>
		/// <param name="ex"></param>
		void ICache<TKey, TEntry>.RaiseExceptionEvent(ICacheEntry<TKey, TEntry> entry, Exception ex)
		{
			if (this.Exception != null) {
				this.Exception(this, new CacheExceptionEventArgs<TKey, TEntry>(entry, ex));
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="state"></param>
		private void CleanTimerCallback(object state)
		{
			try {
				this.Clean();
			} catch (Exception ex) {
				Debug.WriteLine(ex);
			}
		}

		/// <summary>
		/// CacheEntryEventHandler ^̃CxgN܂B
		/// </summary>
		/// <param name="entry"></param>
		/// <param name="handler"></param>
		private void RaiseEntryEvent(
				ICacheEntry<TKey, TEntry> entry, CacheEntryEventHandler<TKey, TEntry> handler)
		{
			if (handler != null) {
				handler(this, new CacheEntryEventArgs<TKey, TEntry>(entry));
			}
		}
	}
}
