using System;
using System.Collections;
using System.Threading;

namespace SystemNeo.Cache
{
	/// <summary>
	/// LbṼGg\܂B
	/// </summary>
	/// <typeparam name="TKey"></typeparam>
	/// <typeparam name="TEntry"></typeparam>
	public abstract class CacheEntry<TKey, TEntry> : IDisposable, ICacheEntry<TKey, TEntry>
			where TEntry : CacheEntry<TKey, TEntry>
	{
		#region internal fields
		internal DateTime lastAccess = DateTime.Now;
		internal CacheEntryState state = CacheEntryState.Preparing;
		#endregion

		#region private fields
		private IAsyncResult asyncResult;
		#endregion

		// public vpeB //

		/// <summary>
		/// ̃GgĂLbV擾܂B
		/// </summary>
		public ICache<TKey, TEntry> Cache { get; private set; }

		/// <summary>
		/// GgێĂIuWFNg擾܂B
		/// </summary>
		public TKey Key { get; private set; }

		/// <summary>
		/// GgɍŌɃANZXꂽ擾܂B
		/// </summary>
		public DateTime LastAccess
		{
			get {
				return this.lastAccess;
			}
		}

		/// <summary>
		/// Gg̏Ԃ擾܂B
		/// </summary>
		public CacheEntryState State
		{
			get {
				return this.state;
			}
		}

		// public Cxg //

		/// <summary>
		/// NGXgꂽGg̒lłƂɔ܂B
		/// </summary>
		public event CacheEntryEventHandler<TKey, TEntry> Prepared;

		// protected RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="cache"></param>
		/// <param name="key"></param>
		protected CacheEntry(ICache<TKey, TEntry> cache, TKey key) : this(cache, key, null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="cache"></param>
		/// <param name="key"></param>
		/// <param name="prepared"></param>
		protected CacheEntry(ICache<TKey, TEntry> cache,
				TKey key, CacheEntryEventHandler<TKey, TEntry> prepared)
		{
			this.Cache = cache;
			this.Key = key;
			if (prepared == null) {
				this.Prepare();
			} else {
				this.Prepared += prepared;
				var prepare = new Action(this.Prepare);
				this.asyncResult = prepare.BeginInvoke(this.PreparedCallback, null);
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		public virtual void Dispose() {}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		protected virtual void PrepareInternal() {}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		private void Prepare()
		{
			try {
				this.PrepareInternal();
				this.state = CacheEntryState.Ready;
			} catch (Exception ex) {
				this.state = CacheEntryState.Error;
				this.Cache.RaiseExceptionEvent(this, ex);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="ar"></param>
		private void PreparedCallback(IAsyncResult ar)
		{
			if (ar.IsCompleted && this.Prepared != null) {
				this.Prepared(this, new CacheEntryEventArgs<TKey, TEntry>(this));
			}
		}
	}
}
