using System;
using System.Runtime.InteropServices;

using SystemNeo;

namespace SystemNeo.Cache
{
	/// <summary>
	/// IuWFNg̃LbV\܂B
	/// </summary>
	/// <typeparam name="TKey"></typeparam>
	/// <typeparam name="TEntry"></typeparam>
	[ComVisible(false)]
	public interface ICache<TKey, TEntry> where TEntry : ICacheEntry<TKey, TEntry>
	{
		// vpeB //

		/// <summary>
		/// ێԂ߂Gg̍폜sԊu擾܂͐ݒ肵܂B
		/// </summary>
		TimeSpan CleanInterval { get; set; }

		/// <summary>
		/// ێĂGg̐擾܂B
		/// </summary>
		int EntryCount { get; }

		/// <summary>
		/// LbVqbg񐔂擾܂B
		/// </summary>
		ulong HitCount { get; }

		/// <summary>
		/// LbV̕ێԂ\܂B
		/// </summary>
		TimeSpan LifeTime { get; set; }

		/// <summary>
		/// ێԂ߂ăLbV폜ꂽGg̐擾܂B
		/// </summary>
		ulong RemoveCount { get; }

		/// <summary>
		/// LbVIuWFNg擾ꂽ񐔂擾܂B
		/// ́ALbVqbg񐔂ƃ~X񐔂Ƃ̘ałB
		/// </summary>
		ulong RequestCount { get; }

		// \bh //

		/// <summary>
		/// LbṼGĝAێԂ߂̂폜܂B
		/// </summary>
		void Clean();

		/// <summary>
		/// LbVIuWFNg擾܂B
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		TEntry Get(TKey key);

		/// <summary>
		/// LbVIuWFNg擾܂B
		/// </summary>
		/// <param name="key"></param>
		/// <param name="invocation"></param>
		/// <returns></returns>
		TEntry Get(TKey key, DelegateInvocation invocation);

		/// <summary>
		/// 
		/// </summary>
		/// <param name="entry"></param>
		/// <param name="ex"></param>
		void RaiseExceptionEvent(ICacheEntry<TKey, TEntry> entry, Exception ex);
	}
}
