using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace SystemNeo
{
	/// <summary>
	/// ̕ϊs܂B
	/// </summary>
	public class CharConverter
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public static readonly CharConverter Empty = new CharConverter();
		
		// internal static tB[h //

		/// <summary>
		/// 
		/// </summary>
		internal static readonly CharConverter DakuonKanaFullWidth
				= new CharConverter(CharUtil.HalfWidthDakuonKanaMap);

		/// <summary>
		/// 
		/// </summary>
		internal static readonly CharConverter HandakuonKanaFullWidth
				= new CharConverter(CharUtil.HalfWidthHandakuonKanaMap);

		/// <summary>
		/// 
		/// </summary>
		internal static readonly CharConverter SimpleKanaFullWidth
				= new CharConverter(CharUtil.HalfWidthKanaMap);

		#region private fields
		private readonly CharConverter reverser;
		private readonly IDictionary<char, char> dic;
		private readonly IDictionary<char, char> reverserDic;
		#endregion

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="charMap"></param>
		public CharConverter(params char[] charMap)
		{
			if (charMap.Length % 2 == 1) {
				throw new ArgumentException("z̒͋łȂ΂Ȃ܂B", "charMap");
			}
			this.dic = new Dictionary<char, char>();
			this.reverserDic = new Dictionary<char, char>();
			for (int i = 0; i < charMap.Length; ) {
				char x = charMap[i++];
				char y = charMap[i++];
				dic[x] = y;
				reverserDic[y] = x;
			}
			this.reverser = new CharConverter(this);
		}

		// private RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="reverser"></param>
		private CharConverter(CharConverter reverser)
		{
			this.dic = reverser.reverserDic;
			this.reverserDic = reverser.dic;
			this.reverser = reverser;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="c"></param>
		/// <returns></returns>
		public char Convert(char c)
		{
			return dic.ContainsKey(c) ? dic[c] : c;
		}

		/// <summary>
		///  CharConverter Ƌt̕ϊs CharConverter 擾܂B
		/// </summary>
		public CharConverter Reverse()
		{
			return this.reverser;
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="cc"></param>
		/// <returns></returns>
		public static explicit operator Func<char, char>(CharConverter cc)
		{
			return cc.Convert;
		}
	}
}
