using System;
using System.CodeDom.Compiler;
using System.Text;

namespace SystemNeo.CodeDom.Compiler
{
	/// <summary>
	/// \[XR[h̃RpCɎsƂɃX[OłB
	/// </summary>
	public class CompileFailedException : Exception
	{
		#region private fields
		private readonly CompilerResults result;
		#endregion

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="result"></param>
		public CompileFailedException(CompilerResults result) : base(MakeMessage(result))
		{
			this.result = result;
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="result"></param>
		/// <returns></returns>
		private static string MakeMessage(CompilerResults result)
		{
			var sb = new StringBuilder();
			foreach (CompilerError err in result.Errors) {
				sb.AppendFormat("[{0}s][{1}] ", err.Line, err.ErrorText);
				sb.Append(Environment.NewLine);
			}
			return sb.ToString();
		}
	}
}
