using System;
using System.Collections;

using SystemNeo;

namespace SystemNeo.Collections
{
	/// <summary>
	/// <see cref="System.Collections.IComparer">IComparer</see> ̃RNV\܂B
	/// </summary>
	public class ComparerCollection : IComparer
	{
		#region private fields
		private IList comparers = new ArrayList();
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="index"></param>
		/// <returns></returns>
		public IComparer this[int index]
		{
			get {
				return (IComparer)this.comparers[index];
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public int Count
		{
			get {
				return this.comparers.Count;
			}
		}

		// public RXgN^ //

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="comparer"></param>
		public void Add(IComparer comparer)
		{
			ArgumentUtil.AssertNull(comparer, "comparer");
			this.comparers.Add(comparer);
		}

		/// <summary>
		/// 
		/// </summary>
		public void Clear()
		{
			this.comparers.Clear();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public virtual int Compare(object x, object y)
		{
			foreach (IComparer comparer in this.comparers) {
				int result = comparer.Compare(x, y);
				if (result != 0) {
					return result;
				}
			}
			return 0;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="index"></param>
		/// <param name="comparer"></param>
		public void Insert(int index, IComparer comparer)
		{
			ArgumentUtil.AssertNull(comparer, "comparer");
			this.comparers.Insert(index, comparer);
		}
	}
}
