using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.ComponentModel;
using System.IO;
using System.Text;

using SystemNeo;
using SystemNeo.Collections.Generic;
using SystemNeo.Text;

namespace SystemNeo.Collections
{
	/// <summary>
	/// fBNViɊւ郁\bh񋟂܂B
	/// </summary>
	public static class DictionaryUtil
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public static IDictionary Create(object obj)
		{
			ArgumentUtil.AssertNull(obj, "obj");
			var result = new Hashtable();
			var properties = TypeDescriptor.GetProperties(obj);
			foreach (PropertyDescriptor property in properties) {
				result[property.Name] = property.GetValue(obj);
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="values"></param>
		/// <returns></returns>
		public static IDictionary Create(IList values)
		{
			ArgumentUtil.AssertNull(values, "values");
			if (values.Count % 2 != 0) {
				throw new ArgumentException();
			}
			var result = new Hashtable();
			for (int i = values.Count - 1; i > 0; i -= 2) {
				result.Add(values[i - 1], values[i]);
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="values"></param>
		/// <returns></returns>
		public static IDictionary<TKey, TValue> Create<TKey, TValue>(IList values)
		{
			ArgumentUtil.AssertNull(values, "values");
			if (values.Count % 2 != 0) {
				throw new ArgumentException();
			}
			var result = new Dictionary<TKey, TValue>();
			for (int i = values.Count - 1; i > 0; i -= 2) {
				result.Add((TKey)values[i - 1], (TValue)values[i]);
			}
			return result;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="dictionary"></param>
		/// <param name="action"></param>
		public static void ForEach<TKey, TValue>(
				this IDictionary dictionary, Action<TKey, TValue> action)
		{
			ArgumentUtil.AssertNull(dictionary, "dictionary");
			ArgumentUtil.AssertNull(action, "action");
			foreach (DictionaryEntry de in dictionary) {
				action((TKey)de.Key, (TValue)de.Value);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="dictionary"></param>
		/// <param name="action"></param>
		public static void ForEach<TKey, TValue>(
				this IDictionary<TKey, TValue> dictionary, Action<TKey, TValue> action)
		{
			ArgumentUtil.AssertNull(dictionary, "dictionary");
			ArgumentUtil.AssertNull(action, "action");
			foreach (var pair in dictionary) {
				action(pair.Key, pair.Value);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="dictionary"></param>
		/// <param name="format"></param>
		/// <returns></returns>
		public static string Format(this IDictionary dictionary, string format)
		{
			return Format(dictionary, format, null);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="dictionary"></param>
		/// <param name="format"></param>
		/// <returns></returns>
		public static string Format<TKey, TValue>(
				this IDictionary<TKey, TValue> dictionary, string format)
		{
			return Format(dictionary, format, null);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="dictionary"></param>
		/// <param name="format"></param>
		/// <param name="formatProvider"></param>
		/// <returns></returns>
		public static string Format(
				this IDictionary dictionary, string format, IFormatProvider formatProvider)
		{
			ArgumentUtil.AssertNull(dictionary, "dictionary");
			ArgumentUtil.AssertNull(format, "format");
			var sb = new StringBuilder();
			var formatters = new FormatParser().Parse(format);
			foreach (IDictionaryFormatter formatter in formatters) {
				formatter.Append(sb, dictionary, formatProvider);
			}
			return sb.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="dictionary"></param>
		/// <param name="format"></param>
		/// <param name="formatProvider"></param>
		/// <returns></returns>
		public static string Format<TKey, TValue>(this IDictionary<TKey, TValue> dictionary,
				string format, IFormatProvider formatProvider)
		{
			ArgumentUtil.AssertNull(dictionary, "dictionary");
			var d = new NonGenericDictionary<TKey, TValue>(dictionary);
			return Format(d, format, formatProvider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="dictionary"></param>
		/// <returns></returns>
		public static NameValueCollection ToNameValueCollection(this IDictionary<string, string> dictionary)
		{
			ArgumentUtil.AssertNull(dictionary, "dictionary");
			var nvc = new NameValueCollection(dictionary.Count);
			foreach (var pair in dictionary) {
				nvc.Add(pair.Key, pair.Value);
			}
			return nvc;
		}

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="pair"></param>
		/// <returns></returns>
		internal static TKey GetKey<TKey, TValue>(KeyValuePair<TKey, TValue> pair)
		{
			return pair.Key;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="pair"></param>
		/// <returns></returns>
		internal static TValue GetValue<TKey, TValue>(KeyValuePair<TKey, TValue> pair)
		{
			return pair.Value;
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		private class FormatParser : Parser
		{
			// protected \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="value"></param>
			/// <param name="sr"></param>
			/// <param name="readers"></param>
			protected override void GetReader(
					string value, out StringReaderNeo sr, out Func<TextElement>[] readers)
			{
				var reader = new FormatReader(value);
				try {
					readers = new Func<TextElement>[] {
						reader.ReadKeyFormat,
						reader.ReadPlainText
					};
					sr = reader;
				} catch (Exception) {
					reader.Close();
					throw;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private class FormatReader : StringReaderNeo
		{
			#region private static fields
			private static readonly Predicate<char> BracketCharFilter = IsBracket;
			private static readonly Predicate<char> KeyNameCharFilter = IsKeyNameChar;
			#endregion

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="value"></param>
			internal FormatReader(string value) : base(value) {}

			// internal \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			internal TextElement ReadKeyFormat()
			{
				if (this.Peek() != '{') {
					return null;
				}
				var sb = new StringBuilder();
				sb.Append(this.Read());
				string key = this.Read(KeyNameCharFilter);
				string format = null;
				sb.Append(key);
				switch (this.Peek()) {
				case ':':
					sb.Append(this.Read());
					format = this.Read(BracketCharFilter, true);
					sb.Append(format);
					if (this.Peek() != '}') {
						throw new ParseException();
					}
					break;
				case '}':
					break;
				default:
					throw new ParseException();
				}
				sb.Append(this.Read());
				return new KeyFormatTextElement(sb.ToString(), key, format);
			}

			/// <summary>
			/// 
			/// </summary>
			/// <returns></returns>
			internal TextElement ReadPlainText()
			{
				string s = this.Read(BracketCharFilter, true);
				return s == string.Empty ? null : new PlainTextElement(s);
			}

			// private static \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="c"></param>
			/// <returns></returns>
			private static bool IsBracket(char c)
			{
				return c == '{' || c == '}';
			}

			/// <summary>
			/// 
			/// </summary>
			/// <param name="c"></param>
			/// <returns></returns>
			private static bool IsKeyNameChar(char c)
			{
				return ! (IsBracket(c) || c == ',' || c == ':');
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private interface IDictionaryFormatter
		{
			/// <summary>
			/// 
			/// </summary>
			/// <param name="sb"></param>
			/// <param name="dictionary"></param>
			/// <param name="formatProvider"></param>
			void Append(StringBuilder sb, IDictionary dictionary, IFormatProvider formatProvider);
		}

		/// <summary>
		/// 
		/// </summary>
		private sealed class KeyFormatTextElement : TextElement, IDictionaryFormatter
		{
			#region private fields
			private readonly string key;
			private readonly string format;
			#endregion

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="sourceText"></param>
			/// <param name="key"></param>
			/// <param name="format"></param>
			internal KeyFormatTextElement(string sourceText, string key, string format)
					: base(sourceText)
			{
				this.key = key;
				this.format = format;
			}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="sb"></param>
			/// <param name="dictionary"></param>
			/// <param name="formatProvider"></param>
			void IDictionaryFormatter.Append(
					StringBuilder sb, IDictionary dictionary, IFormatProvider formatProvider)
			{
				object value = dictionary[key];
				if (this.format == null || ! (value is IFormattable)) {
					sb.Append(value);
				} else {
					var f = (IFormattable)value;
					sb.Append(f.ToString(this.format, formatProvider));
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private sealed class PlainTextElement : TextElement, IDictionaryFormatter
		{
			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="sourceText"></param>
			internal PlainTextElement(string sourceText) : base(sourceText) {}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="sb"></param>
			/// <param name="dictionary"></param>
			/// <param name="formatProvider"></param>
			void IDictionaryFormatter.Append(
					StringBuilder sb, IDictionary dictionary, IFormatProvider formatProvider)
			{
				sb.Append(this.SourceText);
			}
		}
	}
}
