using System;
using System.Collections;
using System.ComponentModel;
using System.Threading;

using SystemNeo;

namespace SystemNeo.Collections
{
	/// <summary>
	/// 
	/// </summary>
	public struct KeySortDefinition
	{
		#region private fields
		private readonly string key;
		private readonly IComparer comparer;
		private readonly SortOrder order;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string Key
		{
			get {
				return this.key;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public IComparer Comparer
		{
			get {
				return this.comparer;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public SortOrder Order
		{
			get {
				return this.order;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="order"></param>
		public KeySortDefinition(string key, SortOrder order) : this(key, null, order) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <param name="comparer"></param>
		/// <param name="order"></param>
		public KeySortDefinition(string key, IComparer comparer, SortOrder order)
		{
			ArgumentUtil.AssertNull(key, "key");
			ArgumentUtil.AssertInvalidEnum(order, "order");
			this.key = key;
			this.comparer = comparer ?? System.Collections.Comparer.Default;
			this.order = order;
		}
	}
}
