using System;
using System.Linq;
using System.Reflection;

namespace SystemNeo
{
	/// <summary>
	/// fQ[gƁA̎sɓnp[^JvZ܂B
	/// </summary>
	public class DelegateInvocation
	{
		#region private fields
		private object[] parameters;
		private int repeat;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public Delegate Delegate { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public MethodInfo Method
		{
			get {
				return this.Delegate.Method;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public object[] Parameters
		{
			get {
				if (this.parameters == null) {
					return new object[] {};
				} else {
					return (object[])this.parameters.Clone();
				}
			}
		}

		/// <summary>
		/// JԂ̉񐔂擾܂͐ݒ肵܂B
		/// </summary>
		public int Repeat
		{
			get {
				return this.repeat;
			}
			set {
				if (repeat < 0) {
					throw new ArgumentOutOfRangeException("Repeat");
				}
				this.repeat = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public object Target
		{
			get {
				return this.Delegate.Target;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="delegate"></param>
		public DelegateInvocation(Delegate @delegate) : this(1, @delegate, null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="delegate"></param>
		/// <param name="params"></param>
		public DelegateInvocation(Delegate @delegate, params object[] @params)
				: this(1, @delegate, @params) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="repeat"></param>
		/// <param name="delegate"></param>
		public DelegateInvocation(int repeat, Delegate @delegate)
				: this(repeat, @delegate, null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="repeat"></param>
		/// <param name="delegate"></param>
		/// <param name="params"></param>
		public DelegateInvocation(int repeat, Delegate @delegate, params object[] @params)
		{
			if (repeat < 0) {
				throw new ArgumentOutOfRangeException("repeat");
			}
			ArgumentUtil.AssertNull(@delegate, "delegate");
			this.repeat = repeat;
			this.Delegate = @delegate;
			this.parameters = @params;
		}

		// public \bh //

		/// <summary>
		/// ݂̃XbhŃfQ[gs܂B
		/// </summary>
		/// <returns></returns>
		public virtual object Invoke()
		{
			object result = null;
			for (int i = 0; i < this.repeat; i++) {
				result = this.Delegate.DynamicInvoke(this.parameters);
			}
			return result;
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="invocation"></param>
		/// <returns></returns>
		public static explicit operator Func<object>(DelegateInvocation invocation)
		{
			ArgumentUtil.AssertNull(invocation, "invocation");
			return invocation.Invoke;
		}
	}
}
