using System;
using System.Collections.Generic;
using System.Reflection;

namespace SystemNeo
{
	/// <summary>
	/// fQ[g̐Ȃǂs\bh񋟂܂B
	/// </summary>
	public static class DelegateUtil
	{
		// public static \bh //

		/// <summary>
		/// ^2̃IuWFNgr郁\bhԂ܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <returns></returns>
		public static Comparison<T> CreateComparison<T>() where T : IComparable
		{
			return (x, y) => {
				if (x == null) {
					return y == null ? 0 : - y.CompareTo(x);
				} else {
					return x.CompareTo(y);
				}
			};
		}

		/// <summary>
		/// ^2̃IuWFNgr郁\bhԂ܂B
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <returns></returns>
		public static Comparison<TValue> CreateComparison<TKey, TValue>() where TKey : IComparable
		{
			return CreateComparison<TKey, TValue>(ObjectUtil.ChangeType<TValue, TKey>);
		}

		/// <summary>
		/// ^2̃IuWFNgr郁\bhԂ܂B
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="keyGetter"></param>
		/// <returns></returns>
		public static Comparison<TValue> CreateComparison
				<TKey, TValue>(Func<TValue, TKey> keyGetter) where TKey : IComparable
		{
			return CreateComparison(CreateComparison<TKey>(), keyGetter);
		}

		/// <summary>
		/// ^2̃IuWFNgr郁\bhԂ܂B
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="comparison"></param>
		/// <param name="keyGetter"></param>
		/// <returns></returns>
		public static Comparison<TValue> CreateComparison
				<TKey, TValue>(Comparison<TKey> comparison, Func<TValue, TKey> keyGetter)
		{
			ArgumentUtil.AssertNull(comparison, "comparison");
			ArgumentUtil.AssertNull(keyGetter, "keyGetter");
			return (x, y) => comparison(keyGetter(x), keyGetter(y));
		}

		/// <summary>
		/// ^2̃IuWFNgr郁\bhԂ܂B
		/// </summary>
		/// <typeparam name="TKey"></typeparam>
		/// <typeparam name="TValue"></typeparam>
		/// <param name="comparer"></param>
		/// <param name="keyGetter"></param>
		/// <returns></returns>
		public static Comparison<TValue> CreateComparison
				<TKey, TValue>(IComparer<TKey> comparer, Func<TValue, TKey> keyGetter)
		{
			ArgumentUtil.AssertNull(comparer, "comparer");
			return CreateComparison(comparer.Compare, keyGetter);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="method"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(MethodInfo method)
		{
			return (T)(object)Delegate.CreateDelegate(typeof(T), method);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="method"></param>
		/// <param name="throwOnBindFailure"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(MethodInfo method, bool throwOnBindFailure)
		{
			return (T)(object)Delegate.CreateDelegate(typeof(T), method, throwOnBindFailure);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="firstArgument"></param>
		/// <param name="method"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(object firstArgument, MethodInfo method)
		{
			return (T)(object)Delegate.CreateDelegate(typeof(T), firstArgument, method);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="target"></param>
		/// <param name="method"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(object target, string method)
		{
			return (T)(object)Delegate.CreateDelegate(typeof(T), target, method);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="target"></param>
		/// <param name="method"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(Type target, string method)
		{
			return (T)(object)Delegate.CreateDelegate(typeof(T), target, method);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="firstArgument"></param>
		/// <param name="method"></param>
		/// <param name="throwOnBindFailure"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(
				object firstArgument, MethodInfo method, bool throwOnBindFailure)
		{
			return (T)(object)Delegate.CreateDelegate(
					typeof(T), firstArgument, method, throwOnBindFailure);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="target"></param>
		/// <param name="method"></param>
		/// <param name="ignoreCase"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(object target, string method, bool ignoreCase)
		{
			return (T)(object)Delegate.CreateDelegate(typeof(T), target, method, ignoreCase);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="target"></param>
		/// <param name="method"></param>
		/// <param name="ignoreCase"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(Type target, string method, bool ignoreCase)
		{
			return (T)(object)Delegate.CreateDelegate(typeof(T), target, method, ignoreCase);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="target"></param>
		/// <param name="method"></param>
		/// <param name="ignoreCase"></param>
		/// <param name="throwOnBindFailure"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(
				object target, string method, bool ignoreCase, bool throwOnBindFailure)
		{
			return (T)(object)Delegate.CreateDelegate(
					typeof(T), target, method, ignoreCase, throwOnBindFailure);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="target"></param>
		/// <param name="method"></param>
		/// <param name="ignoreCase"></param>
		/// <param name="throwOnBindFailure"></param>
		/// <returns></returns>
		public static T CreateDelegate<T>(
				Type target, string method, bool ignoreCase, bool throwOnBindFailure)
		{
			return (T)(object)Delegate.CreateDelegate(
					typeof(T), target, method, ignoreCase, throwOnBindFailure);
		}

		/// <summary>
		/// IuWFNg󂯎AɌŒ̒litrue  false ̂ꂩjԂ\bh擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="result"></param>
		/// <returns></returns>
		[Obsolete("Ƀ_gpĂB")]
		public static Predicate<T> GetFixedPredicate<T>(bool result)
		{
			return (obj) => result;
		}

		/// <summary>
		/// w肳ꂽ Comparison ƋťʂԂ Comparison 擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="comparison"></param>
		/// <returns></returns>
		public static Comparison<T> InvertComparison<T>(Comparison<T> comparison)
		{
			ArgumentUtil.AssertNull(comparison, "comparison");
			// p[^̏ւ
			return (x, y) => comparison(y, x);
		}

		/// <summary>
		/// w肳ꂽ Predicate ƋťʂԂ Predicate 擾܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="match"></param>
		/// <returns></returns>
		public static Predicate<T> InvertPredicate<T>(Predicate<T> match)
		{
			ArgumentUtil.AssertNull(match, "match");
			return (obj) => ! match(obj);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="converters"></param>
		/// <returns></returns>
		public static Func<T, T> JoinConverters<T>(IEnumerable<Func<T, T>> converters)
		{
			ArgumentUtil.AssertNull(converters, "converters");
			return (input) => {
				T result = input;
				foreach (var converter in converters) {
					result = converter(result);
				}
				return result;
			};
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T0"></typeparam>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <param name="converter1"></param>
		/// <param name="converter2"></param>
		/// <returns></returns>
		public static Func<T0, T2> JoinConverters<T0, T1, T2>(
				Func<T0, T1> converter1, Func<T1, T2> converter2)
		{
			ArgumentUtil.AssertNull(converter1, "converter1");
			ArgumentUtil.AssertNull(converter2, "converter2");
			return (input) => converter2(converter1(input));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T0"></typeparam>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <param name="converter1"></param>
		/// <param name="converter2"></param>
		/// <param name="converter3"></param>
		/// <returns></returns>
		public static Func<T0, T3> JoinConverters<T0, T1, T2, T3>(
				Func<T0, T1> converter1,
				Func<T1, T2> converter2,
				Func<T2, T3> converter3)
		{
			ArgumentUtil.AssertNull(converter1, "converter1");
			ArgumentUtil.AssertNull(converter2, "converter2");
			ArgumentUtil.AssertNull(converter3, "converter3");
			return (input) => converter3(converter2(converter1(input)));
		}
	}
}
