using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Drawing
{
	/// <summary>
	/// [WFl[^pĐF𐶐܂B
	/// </summary>
	public class RandomColor
	{
		#region private fields
		private readonly RandomNeo random = new RandomNeo();
		private float maxBrightness = 1.0f;
		private float maxSaturation = 1.0f;
		private float minBrightness = 0.0f;
		private double minHueDifference = 60.0;
		private float minSaturation = 0.0f;
		private Color? lastColor;
		#endregion

		// public vpeB //

		/// <summary>
		/// x̍ől擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(1.0f)]
		public float MaxBrightness
		{
			get {
				return this.maxBrightness;
			}
			set {
				if (value < 0.0f || 1.0f < value) {
					throw new ArgumentOutOfRangeException("MaxBrightness");
				}
				this.maxBrightness = value;
			}
		}

		/// <summary>
		/// ʓx̍ől擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(1.0f)]
		public float MaxSaturation
		{
			get {
				return this.maxSaturation;
			}
			set {
				if (value < 0.0f || 1.0f < value) {
					throw new ArgumentOutOfRangeException("MaxSaturation");
				}
				this.maxSaturation = value;
			}
		}

		/// <summary>
		/// x̍ŏl擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(0.0f)]
		public float MinBrightness
		{
			get {
				return this.minBrightness;
			}
			set {
				if (value < 0.0f || 1.0f < value) {
					throw new ArgumentOutOfRangeException("MinBrightness");
				}
				this.minBrightness = value;
			}
		}

		/// <summary>
		/// O̐FƂ̐F̍̍ŏl擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(60.0)]
		public double MinHueDifference
		{
			get {
				return this.minHueDifference;
			}
			set {
				if (value < 0.0 || 180.0 <= value) {
					throw new ArgumentOutOfRangeException("MinHueDifference");
				}
				this.minHueDifference = value;
			}
		}

		/// <summary>
		/// ʓx̍ŏl擾܂͐ݒ肵܂B
		/// </summary>
		[DefaultValue(0.0f)]
		public float MinSaturation
		{
			get {
				return this.minSaturation;
			}
			set {
				if (value < 0.0f || 1.0f < value) {
					throw new ArgumentOutOfRangeException("MinSaturation");
				}
				this.minSaturation = value;
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public Color Next()
		{
			double hue;
			if (this.lastColor == null) {
				hue = this.random.Next(ColorUtil.MinHue, ColorUtil.MaxHue);
			} else {
				float lastHue = this.lastColor.Value.GetHue();
				do {
					hue = this.random.Next(ColorUtil.MinHue, ColorUtil.MaxHue);
				} while (Math.Abs(hue - lastHue) < this.minHueDifference);
			}
			double saturation = this.random.Next(this.minSaturation, this.maxSaturation);
			double brightness = this.random.Next(this.minBrightness, this.maxBrightness);
			this.lastColor = ColorUtil.FromAhsb(ColorUtil.MaxAlpha, hue, saturation, brightness);
			return this.lastColor.Value;
		}
	}
}
