using System;
using System.Collections;
using System.Text;

namespace SystemNeo
{
	/// <summary>
	/// \܂B
	/// </summary>
	public struct Fraction : IConvertible, IComparable, IFormattable
	{
		// public static tB[h //

		/// <summary>
		/// 
		/// </summary>
		public static readonly Fraction Zero = new Fraction(0, 1, true);

		#region private fields
		private long denominator;
		private long numerator;
		private bool reduced;
		#endregion

		// public vpeB //

		/// <summary>
		/// 擾܂B
		/// </summary>
		public long Denominator
		{
			get {
				return this.denominator;
			}
		}

		/// <summary>
		/// q擾܂B
		/// </summary>
		public long Numerator
		{
			get {
				return this.numerator;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool Reduced
		{
			get {
				return this.reduced;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		public Fraction(long value) : this(value, 1, true) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="numerator">qB</param>
		/// <param name="denominator">B</param>
		public Fraction(long numerator, long denominator) : this(numerator, denominator, false) {}

		// private RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="numerator"></param>
		/// <param name="denominator"></param>
		/// <param name="reduced"></param>
		private Fraction(long numerator, long denominator, bool reduced)
		{
			if (denominator < 0) {
				numerator = -numerator;
				denominator = -denominator;
			}
			this.numerator = numerator;
			this.denominator = denominator;
			this.reduced = (reduced || denominator == 1);
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value1"></param>
		/// <param name="value2"></param>
		/// <returns></returns>
		public static long CalcCommonDenominator(Fraction value1, Fraction value2)
		{
			return MathNeo.LCM(value1.denominator, value2.denominator);
		}

		/// <summary>
		/// ʕs܂B
		/// </summary>
		/// <param name="value1"></param>
		/// <param name="value2"></param>
		public static void CommonizeDenominators(ref Fraction value1, ref Fraction value2)
		{
			long commonDenominator = CalcCommonDenominator(value1, value2);
			long numerator1 = value1.numerator * (commonDenominator / value1.denominator);
			long numerator2 = value2.numerator * (commonDenominator / value2.denominator);
			value1 = new Fraction(numerator1, commonDenominator);
			value2 = new Fraction(numerator2, commonDenominator);
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public int CompareTo(object obj)
		{
			return this.CompareTo((Fraction)obj);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int CompareTo(Fraction value)
		{
			return Math.Sign((this - value).numerator);
		}

		/// <summary>
		/// i񕪂ĂȂԁjs܂B
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public Fraction Enreducible(long value)
		{
			if (value == 0) {
				throw new ArgumentOutOfRangeException("value");
			}
			return new Fraction(this.numerator * value, this.denominator * value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <returns></returns>
		public override bool Equals(object obj)
		{
			return obj is Fraction && this.Equals((Fraction)obj);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Equals(Fraction value)
		{
			if (this.denominator == value.denominator) {
				// ꂪȂAPɕqr
				return this.numerator == value.numerator;
			} else {
				// ꂪقȂꍇ́Aꂼ񕪂Ă݂ĕEqv邩ǂׂ
				Fraction f1 = this.Reduce();
				Fraction f2 = value.Reduce();
				return f1.denominator == f2.denominator && f1.numerator == f2.numerator;
			}
		}

		/// <summary>
		/// t擾܂B
		/// </summary>
		/// <returns></returns>
		public Fraction Invert()
		{
			return new Fraction(this.denominator, this.numerator);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override int GetHashCode()
		{
			Fraction reduced = this.Reduce();
			return (int)(reduced.numerator ^ reduced.denominator);
		}

		/// <summary>
		/// 񕪂s܂B
		/// </summary>
		/// <returns></returns>
		public Fraction Reduce()
		{
			if (this.numerator == 0) {
				return Zero;
			}
			if (this.reduced) {
				return this;
			}
			long gcd = MathNeo.GCD(this.numerator, this.denominator);
			if (gcd > 0) {
				return new Fraction(this.numerator / gcd, this.denominator / gcd, true);
			} else {
				return new Fraction(this.numerator, this.denominator, true);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public decimal ToDecimal()
		{
			return (decimal)this.numerator / this.denominator;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public double ToDouble()
		{
			return (double)this.numerator / this.denominator;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override string ToString()
		{
			return this.ToString(null);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		public string ToString(IFormatProvider provider)
		{
			var sb = new StringBuilder();
			sb.Append(this.numerator.ToString(provider));
			sb.Append("/");
			sb.Append(this.denominator.ToString(provider));
			return sb.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="format"></param>
		/// <param name="formatProvider"></param>
		/// <returns></returns>
		public string ToString(string format, IFormatProvider formatProvider)
		{
			var sb = new StringBuilder();
			sb.Append(this.numerator.ToString(format, formatProvider));
			sb.Append("/");
			sb.Append(this.denominator.ToString(format, formatProvider));
			return sb.ToString();
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private IConvertible ToConvertible()
		{
			return this.ToDouble();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private IConvertible ToConvertibleDecimal()
		{
			return this.ToDecimal();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		TypeCode IConvertible.GetTypeCode()
		{
			return TypeCode.Object;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		bool IConvertible.ToBoolean(IFormatProvider provider)
		{
			throw new InvalidCastException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		byte IConvertible.ToByte(IFormatProvider provider)
		{
			return this.ToConvertible().ToByte(provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		char IConvertible.ToChar(IFormatProvider provider)
		{
			throw new InvalidCastException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		DateTime IConvertible.ToDateTime(IFormatProvider provider)
		{
			throw new InvalidCastException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		decimal IConvertible.ToDecimal(IFormatProvider provider)
		{
			return this.ToDecimal();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		double IConvertible.ToDouble(IFormatProvider provider)
		{
			return this.ToDouble();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		short IConvertible.ToInt16(IFormatProvider provider)
		{
			return this.ToConvertible().ToInt16(provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		int IConvertible.ToInt32(IFormatProvider provider)
		{
			return this.ToConvertible().ToInt32(provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		long IConvertible.ToInt64(IFormatProvider provider)
		{
			return this.ToConvertible().ToInt64(provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		sbyte IConvertible.ToSByte(IFormatProvider provider)
		{
			return this.ToConvertible().ToSByte(provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		float IConvertible.ToSingle(IFormatProvider provider)
		{
			return this.ToConvertible().ToSingle(provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="conversionType"></param>
		/// <param name="provider"></param>
		/// <returns></returns>
		object IConvertible.ToType(Type conversionType, IFormatProvider provider)
		{
			return this.ToConvertibleDecimal().ToType(conversionType, provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		ushort IConvertible.ToUInt16(IFormatProvider provider)
		{
			return this.ToConvertible().ToUInt16(provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		uint IConvertible.ToUInt32(IFormatProvider provider)
		{
			return this.ToConvertible().ToUInt32(provider);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="provider"></param>
		/// <returns></returns>
		ulong IConvertible.ToUInt64(IFormatProvider provider)
		{
			return this.ToConvertible().ToUInt64(provider);
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static bool operator ==(Fraction f1, Fraction f2)
		{
			return f1.Equals(f2);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static bool operator !=(Fraction f1, Fraction f2)
		{
			return ! f1.Equals(f2);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static bool operator <(Fraction f1, Fraction f2)
		{
			CommonizeDenominators(ref f1, ref f2);
			return f1.numerator < f2.numerator;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static bool operator >(Fraction f1, Fraction f2)
		{
			CommonizeDenominators(ref f1, ref f2);
			return f1.numerator > f2.numerator;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f"></param>
		/// <returns></returns>
		public static Fraction operator -(Fraction f)
		{
			return new Fraction(- f.numerator, f.denominator);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f"></param>
		/// <returns></returns>
		public static Fraction operator !(Fraction f)
		{
			return f.Invert();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static Fraction operator +(Fraction f1, Fraction f2)
		{
			CommonizeDenominators(ref f1, ref f2);
			return new Fraction(f1.numerator + f2.numerator, f1.denominator);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static Fraction operator -(Fraction f1, Fraction f2)
		{
			CommonizeDenominators(ref f1, ref f2);
			return new Fraction(f1.numerator - f2.numerator, f1.denominator);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static Fraction operator *(Fraction f1, Fraction f2)
		{
			return new Fraction(f1.numerator * f2.numerator, f1.denominator * f2.denominator);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="f1"></param>
		/// <param name="f2"></param>
		/// <returns></returns>
		public static Fraction operator /(Fraction f1, Fraction f2)
		{
			return new Fraction(f1.numerator * f2.denominator, f1.denominator * f2.numerator);
		}

		// ^ϊZq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static implicit operator Fraction(int value)
		{
			return new Fraction(value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public static implicit operator Fraction(long value)
		{
			return new Fraction(value);
		}
	}
}
