using System;
using System.Collections;
using System.Collections.Generic;

using SystemNeo.Collections.Generic;

namespace SystemNeo
{
	/// <summary>
	/// 
	/// </summary>
	/// <typeparam name="TValue"></typeparam>
	/// <typeparam name="TKey"></typeparam>
	public class KeyCounter<TValue, TKey> : IEnumerable<KeyValuePair<TKey, int>>
	{
		#region private fields
		private readonly IDictionary<TKey, int> countDic;
		private readonly Func<TValue, int> countGetter;
		private readonly Func<TValue, TKey> keyGetter;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="key"></param>
		/// <returns></returns>
		public int this[TKey key]
		{
			get {
				if (this.countDic.ContainsKey(key)) {
					return this.countDic[key];
				} else {
					return 0;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public IEnumerable<TKey> Keys
		{
			get {
				return this.countDic.Keys;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public KeyCounter() : this(SimpleConverter<TValue, TKey>.Default, null, null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="keyGetter"></param>
		public KeyCounter(Func<TValue, TKey> keyGetter) : this(keyGetter, null, null) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="keyGetter"></param>
		/// <param name="countGetter"></param>
		public KeyCounter(Func<TValue, TKey> keyGetter, Func<TValue, int> countGetter)
				: this(keyGetter, null, countGetter) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="keyGetter"></param>
		/// <param name="comparer"></param>
		/// <param name="countGetter"></param>
		public KeyCounter(Func<TValue, TKey> keyGetter,
				IEqualityComparer<TKey> comparer, Func<TValue, int> countGetter)
		{
			ArgumentUtil.AssertNull(keyGetter, "keyGetter");
			this.countDic = new FactoryDictionary<TKey, int>(comparer);
			this.keyGetter = keyGetter;
			this.countGetter = countGetter;
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="keepKeys"></param>
		public void Clear(bool keepKeys)
		{
			if (keepKeys) {
				foreach (TKey key in this.countDic.Keys) {
					this.countDic[key] = 0;
				}
			} else {
				this.countDic.Clear();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public IEnumerator<KeyValuePair<TKey, int>> GetEnumerator()
		{
			return this.countDic.GetEnumerator();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		public void Put(TValue value)
		{
			int count = (this.countGetter == null ? 1 : this.countGetter(value));
			this.countDic[this.keyGetter(value)] += count;
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		IEnumerator IEnumerable.GetEnumerator()
		{
			return this.GetEnumerator();
		}
	}
}
