using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Net;
using System.Security.Cryptography;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;

using SystemNeo;
using SystemNeo.IO;
using SystemNeo.Text;

namespace SystemNeo.Net
{
	/// <summary>
	/// Web ̃\[XɃANZX郁\bh񋟂܂B
	/// </summary>
	public sealed class WebClientEx
	{
		#region private fields
		private int bufferSize = DefaultBufferSize;
		private long speedLimit;
		private IDictionary<HttpStatusCode, bool> httpSuccessDic
				= new Dictionary<HttpStatusCode, bool>();
		private int progressStep;
		private States state = States.Preparing;
		#endregion

		// public 萔 //

		/// <summary>
		/// 
		/// </summary>
		public const int DefaultBufferSize = StreamUtil.DefaultBufferSize;

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(DefaultBufferSize)]
		public int BufferSize
		{
			get {
				return this.bufferSize;
			}
			set {
				if (value <= 0) {
					throw new ArgumentOutOfRangeException("BufferSize");
				}
				this.bufferSize = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public int ProgressStep
		{
			get {
				return this.progressStep;
			}
			set {
				if (value < 0) {
					throw new ArgumentOutOfRangeException("ProgressStep");
				}
				this.progressStep = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public WebRequest Request { get; private set; }

		/// <summary>
		/// _E[h̐xBPʂ bpsB
		/// </summary>
		public long SpeedLimit
		{
			get {
				return this.speedLimit;
			}
			set {
				if (value < 0) {
					throw new ArgumentOutOfRangeException("SpeedLimit");
				}
				this.speedLimit = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public States State
		{
			get {
				return this.state;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public object Tag { get; set; }

		// public Cxg //

		/// <summary>
		/// 
		/// </summary>
		public event WebResponseEventHandler Progress;

		/// <summary>
		/// 
		/// </summary>
		public event WebResponseEventHandler Start;

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="request"></param>
		public WebClientEx(WebRequest request)
		{
			ArgumentUtil.AssertNull(request, "request");
			this.Request = request;
			this.InitializeHttpStatusDic();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="outStream"></param>
		/// <returns></returns>
		public bool DownloadData(Stream outStream)
		{
			return this.DownloadData(outStream, true);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="outStream"></param>
		/// <param name="closeStream"></param>
		/// <returns></returns>
		public bool DownloadData(Stream outStream, bool closeStream)
		{
			WebHeaderCollection headers;
			return this.DownloadData(outStream, closeStream, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="outStream">̓eo͂Xg[B</param>
		/// <param name="headers"></param>
		/// <returns></returns>
		public bool DownloadData(Stream outStream, out WebHeaderCollection headers)
		{
			return this.DownloadData(outStream, true, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="outStream">̓eo͂Xg[B</param>
		/// <param name="closeStream"></param>
		/// <param name="headers"></param>
		/// <returns></returns>
		public bool DownloadData(
				Stream outStream, bool closeStream, out WebHeaderCollection headers)
		{
			ArgumentUtil.AssertNull(outStream, "outStream");
			return this.DownloadData(new StreamProvider(outStream), closeStream, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sp">̓eo͂Xg[B</param>
		/// <param name="headers"></param>
		/// <returns></returns>
		public bool DownloadData(IStreamProvider sp, out WebHeaderCollection headers)
		{
			return this.DownloadData(sp, true, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sp">̓eo͂Xg[B</param>
		/// <param name="closeStream"></param>
		/// <param name="headers"></param>
		/// <returns></returns>
		public bool DownloadData(
				IStreamProvider sp, bool closeStream, out WebHeaderCollection headers)
		{
			ArgumentUtil.AssertNull(sp, "sp");
			using (var response = this.Request.GetResponse()) {
				headers = response.Headers;
				var e = new WebResponseEventArgs(this.Request, response, this.Tag);
				e.Cancel = ! this.IsSucceeded(response);
				if (this.Start != null) {
					this.Start(this, e);
				}
				if (e.Cancel) {
					return false;
				}
				using (var responseStream = response.GetResponseStream()) {
					var outStream = sp.GetStream();
					try {
						return this.DownloadDataInternal(response, responseStream, outStream, e);
					} finally {
						if (closeStream) {
							outStream.Close();
						}
					}
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="file"></param>
		/// <returns></returns>
		public bool DownloadFile(FileInfo file)
		{
			WebHeaderCollection headers;
			return this.DownloadFileInternal(file, false, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="file"></param>
		/// <param name="allowAppend"></param>
		/// <returns></returns>
		public bool DownloadFile(FileInfo file, bool allowAppend)
		{
			WebHeaderCollection headers;
			return this.DownloadFileInternal(file, allowAppend, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="file"></param>
		/// <param name="headers"></param>
		/// <returns></returns>
		public bool DownloadFile(FileInfo file, out WebHeaderCollection headers)
		{
			return this.DownloadFileInternal(file, false, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="file"></param>
		/// <param name="allowAppend"></param>
		/// <param name="headers"></param>
		/// <returns></returns>
		public bool DownloadFile(FileInfo file, bool allowAppend, out WebHeaderCollection headers)
		{
			return this.DownloadFileInternal(file, allowAppend, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public string DownloadString()
		{
			return this.DownloadString(null, true);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="headers"></param>
		/// <returns></returns>
		public string DownloadString(out WebHeaderCollection headers)
		{
			return this.DownloadString(null, true, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="encoding"></param>
		/// <param name="useResponseEncoding"></param>
		/// <returns></returns>
		public string DownloadString(Encoding encoding, bool useResponseEncoding)
		{
			WebHeaderCollection headers;
			return this.DownloadString(encoding, useResponseEncoding, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="encoding">GR[fBOB</param>
		/// <param name="useResponseEncoding">
		///  Content-Type wb_[Ŏw肳ꂽGR[fBOgꍇ trueB
		/// </param>
		/// <param name="headers"></param>
		/// <returns></returns>
		public string DownloadString(
				Encoding encoding, bool useResponseEncoding, out WebHeaderCollection headers)
		{
			using (var ms = new MemoryStream()) {
				if (this.DownloadData(ms, false, out headers)) {
					if (useResponseEncoding) {
						string contentType = headers[HttpResponseHeader.ContentType];
						string charset;
						if (GetCharset(contentType, out charset)) {
							encoding = EncodingUtil.GetEncodingFromWebCharset(charset);
						}
					}
					if (encoding == null) {
						throw new ArgumentException(
								"GR[fBOw肳Ă܂B", "encoding");
					}
					ms.Position = 0;
					using (var reader = new StreamReader(ms, encoding)) {
						return reader.ReadToEnd();
					}
				} else {
					return null;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public Stream GetPostStream()
		{
			return GetPostStreamInternal(this.Request);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="content"></param>
		public void Post(string content)
		{
			this.Post(content, Encoding.ASCII);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="content"></param>
		/// <param name="encoding"></param>
		public void Post(string content, Encoding encoding)
		{
			ArgumentUtil.AssertNull(encoding, "encoding");
			byte[] bytes = encoding.GetBytes(content ?? string.Empty);
			PostInternal(this.Request, bytes);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="params"></param>
		/// <param name="encoding"></param>
		public void Post<T>(IDictionary<string, T> @params, Encoding encoding)
		{
			ArgumentUtil.AssertNull(@params, "@params");
			string boundary = CreateBoundary();
			using (var stream = GetPostStreamInternal(this.Request)) {
				var writer = new StreamWriter(stream, encoding);
				writer.AutoFlush = true;
				writer.NewLine = StringUtil.CrLf;
				foreach (var pair in @params) {
					writer.WriteLine("--" + boundary);
					PostInternal(writer, pair.Key, pair.Value);
				}
				writer.WriteLine("--" + boundary + "--");
			}
			this.Request.ContentType
					= string.Format("{0}; boundary=\"{1}\"", MimeTypes.MultipartFormData, boundary);
		}

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="contentType"></param>
		/// <param name="type"></param>
		/// <param name="subtype"></param>
		/// <param name="charset"></param>
		/// <returns></returns>
		internal bool AnalyzeContentType(
				string contentType, out string type, out string subtype, out string charset)
		{
			string pattern = @"^(?<type>\w+)/(?<subtype>(\w|[-.])+)"
					+ @"(; *charset=(?<charset>(\w|[-.])+))?$";
			Match m = Regex.Match(contentType, pattern, RegexOptions.ECMAScript);
			if (m.Success) {
				type = m.Groups["type"].Value;
				subtype = m.Groups["subtype"].Value;
				charset = m.Groups["charset"].Value;
			} else {
				type = null;
				subtype = null;
				charset = null;
			}
			return m.Success;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="contentType"></param>
		/// <param name="charset"></param>
		/// <returns></returns>
		internal bool GetCharset(string contentType, out string charset)
		{
			string type;
			string subtype;
			if (AnalyzeContentType(contentType, out type, out subtype, out charset)) {
				if (charset != string.Empty) {
					return true;
				}
			}
			return false;
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private static string CreateBoundary()
		{
			var provider = new SHA256CryptoServiceProvider();
			string value = Environment.TickCount.ToString();
			byte[] hash = provider.ComputeHash(Encoding.Default.GetBytes(value));
			var sb = new StringBuilder();
			foreach (byte b in hash) {
				sb.Append(b.ToString("x2"));
			}
			return sb.ToString();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="request"></param>
		/// <returns></returns>
		private static Stream GetPostStreamInternal(WebRequest request)
		{
			request.Method = HttpMethods.Post;
			request.ContentType = MimeTypes.WebFormUrlEncoded;
			return request.GetRequestStream();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="fileName"></param>
		/// <param name="fileStream"></param>
		private static void PostFile(StreamWriter writer, string fileName, Stream fileStream)
		{
			writer.WriteLine("; filename=\"" + fileName + "\"");
			writer.WriteLine("Content-Type: " + MimeTypes.OctetStream);
			writer.WriteLine("Content-Transfer-Encoding: binary");
			writer.WriteLine();
			fileStream.CopyTo(writer.BaseStream);
			writer.WriteLine();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="request"></param>
		/// <param name="bytes"></param>
		private static void PostInternal(WebRequest request, byte[] bytes)
		{
			request.ContentLength = bytes.Length;
			using (var stream = GetPostStreamInternal(request)) {
				stream.Write(bytes, 0, bytes.Length);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="name"></param>
		/// <param name="value"></param>
		private static void PostInternal(StreamWriter writer, string name, object value)
		{
			writer.Write("Content-Disposition: form-data; name=\"" + name + "\"");
			if (value is string) {
				writer.WriteLine();
				writer.WriteLine();
				writer.WriteLine(value);
			} else if (value is FileInfo) {
				var file = (FileInfo)value;
				using (var fileStream = file.OpenRead()) {
					PostFile(writer, file.Name, fileStream);
				}
			} else {
				string typeName = value == null ? "null" : value.GetType().FullName;
				throw new NotSupportedException(
						string.Format("^ %s ̓T|[gĂ܂B", typeName));
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="response"></param>
		/// <param name="responseStream"></param>
		/// <param name="outStream"></param>
		/// <param name="e"></param>
		/// <returns></returns>
		private bool DownloadDataInternal(WebResponse response,
				Stream responseStream, Stream outStream, WebResponseEventArgs e)
		{
			int interval = 0;                   // C^[oiPʁF~bj
			int intervalStep = 1;               //  Read 閈ɃC^[oނ
			if (this.speedLimit > 0) {
				double _interval = 8.0 * this.bufferSize / this.speedLimit * DateTimeUtil.MillisecondsPerSecond;
				while (_interval < 64) {        // C^[o64~bȏɂȂ悤ɂ
					_interval    *= 2;
					intervalStep *= 2;
				}
				interval = (int)_interval;
			}

			bool doProgress = (this.Progress != null && this.progressStep > 0);
			long nextProgress = this.progressStep;
			long totalReadSize = 0;
			var buf = new byte[this.bufferSize];
			
			for (int i = 0; ; i++) {
				if (interval > 0 && i % intervalStep == 0) {
					Thread.Sleep(interval);
				}
				int readSize = responseStream.Read(buf, 0, buf.Length);
				if (readSize <= 0) {
					break;
				}
				outStream.Write(buf, 0, readSize);
				totalReadSize += readSize;
				if (doProgress && totalReadSize >= nextProgress) {
					e.SetReadSize(totalReadSize);
					this.Progress(this, e);
					if (e.Cancel) {
						return false;
					}
					nextProgress += this.progressStep;
				}
			}

			outStream.Flush();
			return (response.ContentLength < 0 || totalReadSize == response.ContentLength);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="file"></param>
		/// <param name="allowAppend">true ̏ꍇA_E[h悤ƂĂRec̐擪 <paramref name="file" /> Ɋi[Ă̂ƌȂAȍ~݂̂̕_E[h܂B</param>
		/// <param name="headers"></param>
		/// <returns></returns>
		private bool DownloadFileInternal(
				FileInfo file, bool allowAppend, out WebHeaderCollection headers)
		{
			ArgumentUtil.AssertNull(file, "file");
			string dirPath = Path.GetDirectoryName(file.FullName);
			Directory.CreateDirectory(dirPath);
			var fsp = new FileStreamProvider(file.FullName, FileMode.Create, FileAccess.Write, FileShare.Read);
			if (allowAppend && file.Exists && this.Request is HttpWebRequest) {
				// ͈̓NGXg
				var request = (HttpWebRequest)this.Request;
				request.AddRange(file.Length);
				this.Start += (sender, e) => {
					var response = (HttpWebResponse)e.Response;
					if (response.StatusCode == HttpStatusCode.PartialContent) {
						fsp.Mode = FileMode.Append;
					}
				};
			}
			return this.DownloadData(fsp, true, out headers);
		}

		/// <summary>
		/// 
		/// </summary>
		private void InitializeHttpStatusDic()
		{
			foreach (var code in EnumUtil.GetValues<HttpStatusCode>()) {
				this.httpSuccessDic[code] = (100 <= (int)code && (int)code < 400);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="response"></param>
		/// <returns></returns>
		private bool IsSucceeded(WebResponse response)
		{
			if (response is HttpWebResponse) {
				var httpResponse = (HttpWebResponse)response;
				return this.httpSuccessDic[httpResponse.StatusCode];
			}
			return true;
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		public enum States
		{
			Preparing,
			Downloading,
			Succeeded,
			Failed
		}
	}
}
