using System;
using System.ComponentModel;
using System.Net;
using System.Runtime.InteropServices;

using SystemNeo;

namespace SystemNeo.Net
{
	[ComVisible(false)]
	public class WebResponseEventArgs : CancelEventArgs
	{
		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public long ReadSize { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public WebRequest Request { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public WebResponse Response { get; private set; }

		/// <summary>
		/// 
		/// </summary>
		public object Tag { get; set; }

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="request"></param>
		/// <param name="response"></param>
		/// <param name="tag"></param>
		public WebResponseEventArgs(WebRequest request, WebResponse response, object tag)
			: this(request, response, tag, 0) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="request"></param>
		/// <param name="response"></param>
		/// <param name="tag"></param>
		/// <param name="readSize"></param>
		public WebResponseEventArgs(WebRequest request,
				WebResponse response, object tag, long readSize) : base(false)
		{
			ArgumentUtil.AssertNull(request, "request");
			ArgumentUtil.AssertNull(response, "response");
			this.Request = request;
			this.Response = response;
			this.Tag = tag;
			this.ReadSize = readSize;
		}

		// internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="readSize"></param>
		internal void SetReadSize(long readSize)
		{
			this.ReadSize = readSize;
		}
	}
}
