using System;
using System.Reflection;

namespace SystemNeo
{
	/// <summary>
	/// 
	/// </summary>
	public static class Operators
	{
		// public static \bh //

		/// <summary>
		/// rbgƂ̘_ς߂܂B
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static object BitwiseAnd(object x, object y)
		{
			return BitwiseInternal(BitwiseAnd, x, y);
		}

		/// <summary>
		/// rbgƂ̘_ς߂܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static T BitwiseAnd<T>(T x, T y)
		{
			return (T)BitwiseAnd(typeof(T), x, y);
		}

		/// <summary>
		/// rbgƂ̘_a߂܂B
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static object BitwiseOr(object x, object y)
		{
			return BitwiseInternal(BitwiseOr, x, y);
		}

		/// <summary>
		/// rbgƂ̘_a߂܂B
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public static T BitwiseOr<T>(T x, T y)
		{
			return (T)BitwiseOr(typeof(T), x, y);
		}

		// internal static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		internal static object BitwiseAnd(Type type, object x, object y)
		{
			if (type.Equals(typeof(sbyte))) {
				sbyte _x = Convert.ToSByte(x);
				sbyte _y = Convert.ToSByte(y);
				return _x & _y;
			}
			if (type.Equals(typeof(byte))) {
				byte _x = Convert.ToByte(x);
				byte _y = Convert.ToByte(y);
				return _x & _y;
			}
			if (type.Equals(typeof(short))) {
				short _x = Convert.ToInt16(x);
				short _y = Convert.ToInt16(y);
				return _x & _y;
			}
			if (type.Equals(typeof(ushort))) {
				ushort _x = Convert.ToUInt16(x);
				ushort _y = Convert.ToUInt16(y);
				return _x & _y;
			}
			if (type.Equals(typeof(int))) {
				int _x = Convert.ToInt32(x);
				int _y = Convert.ToInt32(y);
				return _x & _y;
			}
			if (type.Equals(typeof(uint))) {
				uint _x = Convert.ToUInt32(x);
				uint _y = Convert.ToUInt32(y);
				return _x & _y;
			}
			if (type.Equals(typeof(long))) {
				long _x = Convert.ToInt64(x);
				long _y = Convert.ToInt64(y);
				return _x & _y;
			}
			if (type.Equals(typeof(ulong))) {
				ulong _x = Convert.ToUInt64(x);
				ulong _y = Convert.ToUInt64(y);
				return _x & _y;
			}
			throw new NotSupportedException();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		internal static object BitwiseOr(Type type, object x, object y)
		{
			if (type.Equals(typeof(sbyte))) {
				sbyte _x = Convert.ToSByte(x);
				sbyte _y = Convert.ToSByte(y);
				return _x | _y;
			}
			if (type.Equals(typeof(byte))) {
				byte _x = Convert.ToByte(x);
				byte _y = Convert.ToByte(y);
				return _x | _y;
			}
			if (type.Equals(typeof(short))) {
				short _x = Convert.ToInt16(x);
				short _y = Convert.ToInt16(y);
				return _x | _y;
			}
			if (type.Equals(typeof(ushort))) {
				ushort _x = Convert.ToUInt16(x);
				ushort _y = Convert.ToUInt16(y);
				return _x | _y;
			}
			if (type.Equals(typeof(int))) {
				int _x = Convert.ToInt32(x);
				int _y = Convert.ToInt32(y);
				return _x | _y;
			}
			if (type.Equals(typeof(uint))) {
				uint _x = Convert.ToUInt32(x);
				uint _y = Convert.ToUInt32(y);
				return _x | _y;
			}
			if (type.Equals(typeof(long))) {
				long _x = Convert.ToInt64(x);
				long _y = Convert.ToInt64(y);
				return _x | _y;
			}
			if (type.Equals(typeof(ulong))) {
				ulong _x = Convert.ToUInt64(x);
				ulong _y = Convert.ToUInt64(y);
				return _x | _y;
			}
			throw new NotSupportedException();
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="operator"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		private static object BitwiseInternal(TypedBinaryOperator @operator, object x, object y)
		{
			ArgumentUtil.AssertNull(@operator, "operator");
			ArgumentUtil.AssertNull(x, "x");
			ArgumentUtil.AssertNull(y, "y");
			Type tx = x.GetType();
			Type ty = y.GetType();
			if (tx == ty) {
				return @operator(tx, x, y);
			} else {
				throw new TargetException();
			}
		}
	}
}
