using System;
using System.IO;
using System.Text.RegularExpressions;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public class FormatExpressionFormatter : AbstractFormatter
	{
		#region private fields
		private readonly string formatExpression;
		#endregion

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="formatExpression"></param>
		public FormatExpressionFormatter(string formatExpression)
		{
			this.formatExpression = formatExpression;
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="value"></param>
		protected internal override void WriteToInternal(TextWriter writer, object value)
		{
			if (this.formatExpression == null || this.formatExpression.Length == 0) {
				throw new ArgumentException();
			}
			string format = this.formatExpression;
			if (! Regex.IsMatch(format, @"^\{0(,[+-]\d+)?(:[^}]+)?\}$")) {
				format = "{0:" + format + "}";
			}
			writer.Write(format, value);
		}
	}
}
