using System;
using System.Collections;
using System.Collections.Generic;

using SystemNeo;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public abstract class Parser : IParser
	{
		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public ICollection<TextElement> Parse(string value)
		{
			var list = new List<TextElement>();
			this.Parse(value, list);
			return list;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="collection"></param>
		public void Parse(string value, ICollection<TextElement> collection)
		{
			ArgumentUtil.AssertNull(collection, "collection");
			this.ParseInternal(value, collection.Add);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public IEnumerable<TextElement> ParseGradually(string value)
		{
			StringReaderNeo sr;
			Func<TextElement>[] readers;
			this.GetReader(value, out sr, out readers);
			using (sr) {
				while (sr.Peek() >= 0) {
					yield return GetNextElement(readers);
				}
			}
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="sr"></param>
		/// <param name="readers"></param>
		protected abstract void GetReader(
				string value, out StringReaderNeo sr, out Func<TextElement>[] readers);

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="readers"></param>
		/// <returns></returns>
		private static TextElement GetNextElement(Func<TextElement>[] readers)
		{
			foreach (var reader in readers) {
				TextElement elem = reader();
				if (elem != null) {
					return elem;
				}
			}
			throw new ParseException("߂łȂ񂪂܂B");
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		/// <param name="adder"></param>
		private void ParseInternal(string value, Action<TextElement> adder)
		{
			StringReaderNeo sr;
			Func<TextElement>[] readers;
			this.GetReader(value, out sr, out readers);
			using (sr) {
				while (sr.Peek() >= 0) {
					adder(GetNextElement(readers));
				}
			}
		}
	}
}
