using System.IO;
using SystemNeo.CodeDom.Compiler;
using NUnit.Framework;

namespace SystemNeoTest.CodeDom.Compiler.CSharpCodeExecutorTest
{
	[TestFixture]
	public class Execute
	{
		[Test]
		public void Normal()
		{
			// 
			var executor = new CSharpCodeExecutor();
			executor.Source = @"
				public string ReturnZZZ() {
					return new string('Z', 3);
				}
				";
			executor.Compile();

			// s
			object retValue = executor.Execute("ReturnZZZ");

			// 
			Assert.That(retValue, Is.EqualTo("ZZZ"));
		}

		[Test]
		public void NormalWindow()
		{
			// 
			var executor = new CSharpCodeExecutor();
			executor.ImportingNamespaces.Add("System.Windows.Forms");
			executor.Source = @"
				public void ShowForm(string text) {
					Form form = new Form();
					form.Text = text;
					form.Show();
				}
				";
			executor.Compile();

			// s
			executor.Execute("ShowForm", "FormX");
		}

		[Test]
		public void ̃\bh()
		{
			// 
			var executor = new CSharpCodeExecutor();
			executor.ImportingNamespaces.Add("System.Collections.Generic");
			executor.Source = @"
				private string UpperCase(string s) {
					return s.ToUpper();
				}
				public object Main() {
					List<string> list = new List<string>();
					list.Add(UpperCase(list.GetType().Name));
					return list;
				}
				";
			executor.Compile();

			// s
			object retValue = executor.Execute("Main");

			// 
			var list = (System.Collections.Generic.List<string>)retValue;
			Assert.That(list.Count, Is.EqualTo(1));
			Assert.That(list[0], Is.EqualTo("LIST`1"));
		}
	}
}
