using System;
using System.ComponentModel;
using SystemNeo;
using NUnit.Framework;

namespace SystemNeoTest.DateTimeUtilTest
{
	[TestFixture]
	public class GetFirstDateOfWeek
	{
		[Test]
		public void T()
		{
			// 
			DateTime dt = DateTime.ParseExact("2006/1/2 12:00", "yyyy/M/d H:mm", null);

			// s
			DateTime result = DateTimeUtil.GetFirstDateOfWeek(dt, DayOfWeek.Monday);

			// 
			Assert.AreEqual("2006/1/2 0:00", result.ToString("yyyy/M/d H:mm"));
		}

		[Test]
		public void T߈ȊO()
		{
			// 
			DateTime dt = DateTime.ParseExact("2006/1/4 12:00", "yyyy/M/d H:mm", null);

			// s
			DateTime result = DateTimeUtil.GetFirstDateOfWeek(dt, DayOfWeek.Sunday);

			// 
			Assert.AreEqual("2006/1/1 0:00", result.ToString("yyyy/M/d H:mm"));
		}

		[Test][ExpectedException(typeof(InvalidEnumArgumentException))]
		public void sDayOfWeek()
		{
			// 
			DateTime dt = DateTime.ParseExact("2006/1/4 12:00", "yyyy/M/d H:mm", null);

			// s
			DateTime result = DateTimeUtil.GetFirstDateOfWeek(dt, (DayOfWeek)100);
		}
	}
}
