/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobWorker;

/**
 * Rg[uCNp[JNXB 
 * <code>JobWorker</code>̎s`NRg[uCNsB
 * 
 */
public class ControlBreakWorker extends JobWorker {

    /**
     * Rg[uCNpNXB
     */
    private ControlBreakProcessor controlBreakProcessor = null;
    
    /**
     * <code>Chunk</code> ̏ARg[uCN̐ݒ肪
     * Rg[uCNnhsB
     *
     * @param chunk Rg[uCNpΏۃf[^i[`N
     * @param jobStatus WuXe[^X
     */
    @Override
    public void work(Chunk chunk, JobStatus jobStatus) {
        ControlBreakChunk controlBreakChunk = (ControlBreakChunk) chunk;
        super.work(chunk, jobStatus);

        // ÎƂ́ARg[uCNsȂ
        if (!jobStatus.isContinue()) {
            return;
        }

        List<LinkedHashMap<String, Object>> batchUpdateMapList = 
            new ArrayList<LinkedHashMap<String, Object>>();

        // `N͈͂ƃRg[uCN͈͂Rg[uCN
        // ăRg[uCNsB
        if (controlBreakChunk.size() > 1) {
            controlBreakProcessor.doChunkControlBreak(controlBreakChunk,
                    jobStatus, batchUpdateMapList);
        }

        if (jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY) {
            // Rg[uCNnhɂĐIƂ
            processBatchUpdate(controlBreakChunk.getJobContext(), jobStatus,
                    batchUpdateMapList);
            return;
        } else if (!jobStatus.isContinue()) {
            // ُIAfÎƂ́A㑱̃Rg[uCN
            // sȂ
            return;
        }

        // ŏI`Nłꍇ́ASgX`bNuCNsB
        if (controlBreakChunk.isEndChunk()) {
            // ŏI`NEND_MARK݂̂̂Ƃ͏Ȃ
            if (controlBreakChunk.size() > 1) {
                controlBreakProcessor.doAllTransChunkControlBreak(
                        controlBreakChunk, jobStatus, batchUpdateMapList);
            }
        } else {
            // `N͈͂Rg[uCN͈͂LRg[u
            // CNɂăRg[uCNsB
            controlBreakProcessor.doTransChunkControlBreak(controlBreakChunk,
                    jobStatus, batchUpdateMapList);
        }

        if (jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY
                || jobStatus.isContinue()) {
            // Rg[uCNnhɂĐIƂA܂͏
            // pԂłƂ
            processBatchUpdate(controlBreakChunk.getJobContext(), jobStatus,
                    batchUpdateMapList);
        }
    }
    
    /**
     * Rg[uCNpNX擾B
     * 
     * @param controlBreakProcessor
     *            Rg[uCNpNX
     */
    public void setControlBreakProcessor(
            ControlBreakProcessor controlBreakProcessor) {
        this.controlBreakProcessor = controlBreakProcessor;
    }
}
