/*
 * linuxrc_old.c
 *
 * linuxrc program for initrd.
 *
 * Copyright (C) 2005  NTT DATA Corporation
 *
 * Version: 1.0 2005/11/11
 *
 * This is a linuxrc used for mounting root as loopback.
 * Usally, the linuxrc is a nash script, which can't stop when
 * any error occurs and continues until kernel panic.
 * This program stops if any error occurs.
 *
 * You can use diet to reduce the size of executable file.
 * ( [diet] gcc -Wall -O3 --static -s -o linuxrc_old.exe linuxrc_old.c )
 *
 */
#define _FILE_OFFSET_BITS 64
#define _LARGEFILE_SOURCE
#define _LARGEFILE64_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/mount.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#define dev_t unsigned short int
#include <linux/loop.h>
#include <linux/unistd.h>
#define MNT_DETACH 0x00000002
int pivot_root(const char *new_root, const char *put_old);

static int mount_flag = 0;

static void WaitKey(void) {
	int c;
	fprintf(stderr, "Press 'Enter' to continue, or 'Ctrl'-'Alt'-'Delete' to reboot.\n");
	while (1) {
		if ((c = getchar()) != EOF) {
			if (c == '\n') break;
		} else {
			sleep(10);
		}
	}
}

static int losetup(const char *dev, const char *file) {
	struct loop_info loopinfo;
	int dev_fd, file_fd, err = 0;
	int mode = O_RDONLY;
	if (mount_flag == 0) {
		if ((file_fd = open(file, O_RDWR | O_LARGEFILE)) == EOF) {
			if (errno != EROFS) return errno;
			mount_flag = MS_RDONLY;
		} else {
			mode = O_RDWR;
			goto ok;
		}
	}
	if ((file_fd = open(file, O_RDONLY | O_LARGEFILE)) == EOF) return errno;
 ok: ;
	if ((dev_fd = open(dev, mode | O_LARGEFILE)) == EOF) {
		err = errno;
		close(file_fd);
		return err;
	}
	memset(&loopinfo, 0, sizeof(loopinfo));
	strncpy(loopinfo.lo_name, file, sizeof(loopinfo.lo_name) - 1);
	if (ioctl(dev_fd, LOOP_SET_FD, file_fd) == EOF) {
		err = errno;
		goto out;
	}
	if (ioctl(dev_fd, LOOP_SET_STATUS, &loopinfo) == EOF) {
		err = errno;
		ioctl(dev_fd, LOOP_CLR_FD, 0);
		goto out;
	}
 out: ;
	close(dev_fd);
	close(file_fd);
	return err;
}

static const char *GetFSType(const char *filename) {
	static unsigned char buffer[65536 + 1024];
	const char *fstype = NULL;
	int fd = open(filename, O_RDONLY | O_LARGEFILE);
	if (fd == EOF) return NULL;
	memset(buffer, 0, sizeof(buffer));
	read(fd, (char *) buffer, sizeof(buffer));
	close(fd);
	if (buffer[0x438 + 1] == 0xEF && buffer[0x438] == 0x53) {
		if ((buffer[0x45C] & 4) == 4) fstype = "ext3"; else fstype = "ext2";
	} else if (memcmp(buffer + 32769, "CD001", 5) == 0 || memcmp(buffer + 37633, "CD001", 5) == 0) {
		fstype = "iso9660";
	} else if (buffer[0x1FE] == 0x55 && buffer[0x1FF] == 0xAA && buffer[0] == 0xEB && buffer[1] == 0x3C && memcmp(buffer + 0x36, "FAT", 3) == 0) {
		fstype = "vfat";
	} else if (buffer[0x1FE] == 0x55 && buffer[0x1FF] == 0xAA && memcmp(buffer + 0x52, "FAT32", 5) == 0) {
		fstype = "vfat";
	} else if (memcmp(buffer + 65588, "ReIsErFs", 8) == 0 || memcmp(buffer + 65588, "ReIsEr2Fs", 9) == 0) {
		fstype = "reiserfs";
	} else if (memcmp(buffer, "XFSB", 4) == 0) {
		fstype = "xfs";
	} else if (memcmp(buffer + 32768, "JFS1", 4) == 0) {
		fstype = "jfs";
	}
	return fstype;
}

int main(int argc, char *argv[]) {
	FILE *fp;
	unsigned int root = 0;
	int err;
	const char *container_fstype = NULL;
	const char *image_fstype = NULL;
	const char *rootimg_path = "/loopfs/rootimg";
	mkdir("/sysroot", 0755);
	mkdir("/proc", 0755);
	mkdir("/loopfs", 0755);
	mkdir("/lib", 0755);
	mkdir("/etc", 0755);
	mkdir("/sbin", 0755);
	mkdir("/dev", 0755);
	mkdir("/bin", 0755);
	if (mount("none", "/proc", "proc", 0, NULL) == EOF) {
		fprintf(stderr, "'mount -t proc none /proc' faild : %s\n", strerror(errno));
		WaitKey();
	}
	if ((fp = fopen("/proc/cmdline", "r")) != NULL) {
		char buffer[1024];
		memset(buffer, 0, sizeof(buffer));
		if (fgets(buffer, sizeof(buffer) - 1, fp) != NULL) {
			
			if (strstr(buffer, "readonly") != NULL) mount_flag = MS_RDONLY;
			
			{
				char *container = strstr(buffer, "CONTAINER=");
				if (container != NULL) {
					static char buffer[128];
					char *cp, c;
					cp = container; while (*cp > ' ') cp++; c = *cp; *cp = '\0';
					container += 10;
					memset(buffer, 0, sizeof(buffer));
					strncpy(buffer, container, sizeof(buffer) - 1);
					container_fstype = buffer;
					if (strcmp(buffer, "iso9660") == 0) mount_flag = MS_RDONLY;
					*cp = c;
				}
			}

			{
				char *image = strstr(buffer, "IMAGE=");
				if (image != NULL) {
					static char buffer[128];
					char *cp, c;
					cp = image; while (*cp > ' ') cp++; c = *cp; *cp = '\0';
					image += 6;
					memset(buffer, 0, sizeof(buffer));
					strncpy(buffer, image, sizeof(buffer) - 1);
					image_fstype = buffer;
					*cp = c;
				}
			}

			{
				char *rootimg = strstr(buffer, "ROOTIMG=");
				if (rootimg != NULL) {
					static char buffer[1024];
					char *cp, c;
					memset(buffer, 0, sizeof(buffer));
					cp = rootimg; while (*cp > ' ') cp++; c = *cp; *cp = '\0';
					snprintf(buffer, sizeof(buffer) - 1, "/loopfs/%s", rootimg + 8);
					rootimg_path = buffer;
					*cp = c;
				}
			}

#if defined(DEVFS) // To convert "root=/dev/cdroms/cdrom0".
			{
				char *rootdev = strstr(buffer, "root=");
				if (rootdev != NULL) {
					char *cp = rootdev, c;
					struct stat buf;
					while (*cp > ' ') cp++; c = *cp; *cp = '\0';
					rootdev += 5;
					if (stat(rootdev, &buf) == 0 && S_ISBLK(buf.st_mode)) root = buf.st_rdev;
					*cp = c;
				}
			}
#endif

		}
		fclose(fp);
	}
	if (root == 0) {
		if ((fp = fopen("/proc/sys/kernel/real-root-dev", "r")) == NULL || fscanf(fp, "%u", &root) != 1) {
			fprintf(stderr, "'cat /proc/sys/kernel/real-root-dev' failed : %s\n", strerror(errno));
			WaitKey();
		}
		fclose(fp);
	}
	unlink("/dev/root");
	if (mknod("/dev/root", S_IFBLK | 0600, (dev_t) root) == EOF) {
		fprintf(stderr, "'mkrootdev /dev/root' faild : rootdev=%X: %s\n", root, strerror(errno));
		WaitKey();
	}
	if (!container_fstype) {
		int trial;
		for (trial = 0; trial <= 50; trial++) {
			int fd = open("/dev/root", O_RDONLY);
			struct timeval tv;
			if (fd != EOF) {
				close(fd);
				break;
			}
			if (errno != ENXIO && errno != ENODEV) break;
			tv.tv_sec = 0; tv.tv_usec = 100 * 1000;
			select(0, NULL, NULL, NULL, &tv);
		}
		container_fstype = GetFSType("/dev/root");
	}
	if (!container_fstype) {
		fprintf(stderr, "Can't get container's fstype. Try passing CONTAINER= option to kernel.\n");
		WaitKey();
	}
	{
		int trial;
		for (trial = 0; trial <= 50; trial++) {
			errno = 0;
			if (mount("/dev/root", "/loopfs", container_fstype, mount_flag, NULL) == 0) break;
			if (errno == ENXIO) {
				struct timeval tv;
				tv.tv_sec = 0; tv.tv_usec = 100 * 1000;
				select(0, NULL, NULL, NULL, &tv);
			} else if (errno == EROFS) {
				mount_flag = MS_RDONLY;
			} else {
				break;
			}
		}
		if (errno) {
			fprintf(stderr, "'mount -t %s /dev/root /loopfs' failed : rootdev=%X: %s(%d)\n", container_fstype, root, strerror(errno), errno);
			WaitKey();
		}
	}
	mknod("/dev/loop0", S_IFBLK | 0600, (dev_t) 0x700);
	if ((err = losetup("/dev/loop0", rootimg_path)) > 0) {
		fprintf(stderr, "'losetup /dev/loop0 %s' failed : %s\n", rootimg_path, strerror(err));
		WaitKey();
	}
	if (!image_fstype) image_fstype = GetFSType("/dev/loop0");
	if (!image_fstype) {
		fprintf(stderr, "Can't get image's fstype. Try passing IMAGE= option to kernel.\n");
		WaitKey();
	}
	
	if (mount("/dev/loop0", "/sysroot", image_fstype, mount_flag, NULL) == EOF) {
		fprintf(stderr, "'mount -t %s /dev/loop0 /sysroot' failed : %s\n", image_fstype, strerror(errno));
		WaitKey();
	}
	if ((fp = fopen("/proc/sys/kernel/real-root-dev", "w")) == NULL || fprintf(fp, "0x100") != 5) {
		fprintf(stderr, "'echo 0x100 > /proc/sys/kernel/real-root-dev' failed : %s\n", strerror(errno));
		WaitKey();
	}
	fclose(fp);
	if (pivot_root("/sysroot", "/sysroot/initrd") == EOF) {
		fprintf(stderr, "'pivot_root /sysroot /sysroot/initrd' failed : %s\n", strerror(errno));
		WaitKey();
	}
	if (umount("/initrd/proc") == EOF) {
		fprintf(stderr, "'umount /initrd/proc' failed : %s\n", strerror(errno));
		WaitKey();
	}
	if (umount2("/initrd/loopfs", MNT_DETACH) == EOF) {
		fprintf(stderr, "'unmount -l /initrd/loopfs' failed : %s\n", strerror(errno));
		WaitKey();
	}
	if (umount2("/initrd", MNT_DETACH) == EOF) {
		fprintf(stderr, "'umount -l /initrd' failed : %s\n", strerror(errno));
		WaitKey();
	}
	return 0;
}
