#include "ETTailControl.h"
#include "Motor.h"

using namespace ecrobot;

extern "C"
{
	#include "ecrobot_interface.h"
};

const int ETTailControl::ANGLE_STAND_UP = 115;
const int ETTailControl::ANGLE_DRIVE = 3;
const float ETTailControl::P_GAIN = 2.5F;
const int ETTailControl::PWM_ABS_MAX = 60;
const int ETTailControl::RESET_SPEED = -50;
const int ETTailControl::RESET_PROCESSING_INTERVAL = 64;

/*  */
void ETTailControl::Init()
{
	/* ۂēȂȂC]pxZbg */
	m_tailMotor.reset();
	long currentDegree = 0;
	long lastDegree = 0;
	
	do {
		lastDegree = currentDegree;
		m_tailMotor.setPWM(RESET_SPEED);
		systick_wait_ms(RESET_PROCESSING_INTERVAL);

		currentDegree = m_tailMotor.getCount();
	} while(currentDegree < lastDegree);

	m_angle = 0;
	m_tailMotor.reset();
}

/* Ks */
void ETTailControl::Control()
{
	float pwm = (static_cast<float>(m_angle) - static_cast<float>(m_tailMotor.getCount()))*P_GAIN;	/* ᐧ */
	/* PWMo͖Oa */
	if (pwm > PWM_ABS_MAX)
	{
		pwm = PWM_ABS_MAX;
	}
	else if (pwm < -PWM_ABS_MAX)
	{
		pwm = -PWM_ABS_MAX;
	}

	m_tailMotor.setPWM((signed char)pwm);
}

