#pragma once

template <class T>
class PID
{
	T m_kp;
	T m_ki;
	T m_kd;
	T m_clipMin;
	T m_clipMax;
	T m_integralClipMin;
	T m_integralClipMax;
	T m_prevDiff;
	T m_sumDiff;
public:
	PID();
	PID(const T& kp, const T& ki, const T& kd);
	~PID(void);
	//
	T CalcControlValue(const T& diff);
	void SetClip(const T& clipMin, const T& clipMax);
	void SetIntegralClip(const T& clipMin, const T& clipMax);
	void ResetPrevDiff();
};

template<class T>
PID<T>::PID(const T& kp, const T& ki, const T& kd)
	: m_kp(kp), m_ki(ki), m_kd(kd),
	m_clipMin(0), m_clipMax(-1), m_integralClipMin(0), m_integralClipMax(-1),
	m_prevDiff(0), m_sumDiff(0)
{
}

template<class T>
PID<T>::~PID(void)
{
}

template<class T>
T PID<T>::CalcControlValue(const T& diff)
{
	T val = m_kp * diff + m_kd * (diff - m_prevDiff) + m_ki * m_sumDiff;
	m_sumDiff += diff;
	m_prevDiff = diff;

	if(m_integralClipMin <= m_integralClipMax){
		if(m_sumDiff < m_integralClipMin){
			m_sumDiff = m_integralClipMin;
		}
		if(m_integralClipMax < m_sumDiff){
			m_sumDiff = m_integralClipMax;
		}
	}

	if(m_clipMin <= m_clipMax){
		if(val < m_clipMin){
			val = m_clipMin;
		}
		if(m_clipMax < val){
			val = m_clipMax;
		}
	}
	return val;
}

template<class T>
void PID<T>::SetClip(const T& clipMin, const T& clipMax)
{
	m_clipMin = clipMin;
	m_clipMax = clipMax;
}

template<class T>
void PID<T>::SetIntegralClip(const T& clipMin, const T& clipMax)
{
	m_integralClipMin = clipMin;
	m_integralClipMax = clipMax;
}

template<class T>
void PID<T>::ResetPrevDiff()
{
	m_prevDiff = 0;
	m_sumDiff = 0;
}
