/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: library.h 616 2012-06-19 02:17:36Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "../header/plugin.h"
#include <wx/file.h>

//******************************************************************************
//    Functions
//******************************************************************************

wxString MakeCommandLineSend(const wxString & szCommandLine, TPI_SWITCHES * swInfo = NULL, const wxArrayString & asFiles = wxArrayString(), const wxString & szResponceFileName = wxEmptyString);
wxString MakeResponceFile(const wxArrayString & asFiles, bool bQuote, bool bUnicode = false);
wxString MB2String(const char * sz);
wxString UTF82String(const char * sz);
wxString WC2String(const wchar_t * sz);

inline void RemoveCwdFromSearchPath(void)
{
#ifdef __WINDOWS__
	static void * p = (void *) ::GetProcAddress(::GetModuleHandleW(L"kernel32.dll"), "SetDllDirectoryW");
	if (p != NULL)
	{
		((int (__stdcall *)(const wchar_t *)) p)(L"");
	}
#endif
}

#ifdef __WINDOWS__
inline wxDateTime FileTimeToWxDateTime(FILETIME * pft)
{
	FILETIME ftLocal;
	SYSTEMTIME st;
	if (! ::FileTimeToLocalFileTime(pft, & ftLocal) || ! ::FileTimeToSystemTime(& ftLocal, & st))
	{
		return (time_t) 0;
	}
	wxDateTime dt(st.wDay, wxDateTime::Month(st.wMonth - 1), st.wYear, st.wHour, st.wMinute, st.wSecond, st.wMilliseconds);
	return dt;
}
#endif

#ifdef MYUSE_LIBPATH
wxString g_szLibPath;

#ifdef __WINDOWS__
BOOL WINAPI DllMain(HINSTANCE hLib, DWORD dwReason, void *)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		wchar_t szName[1024];
		::GetModuleFileName(hLib, szName, sizeof(szName) - 1);
		g_szLibPath = wxFileName(WC2String(szName)).GetPath(true);
	}
	return TRUE;
}
#else
#include <dlfcn.h>
// GCC4.7ではg_szLibPathへの代入で不正終了してしまうので、myMakeXMLNameの初回に呼ぶように変更。
//__attribute__((constructor))
void inline on_load(void)
{
	Dl_info dl;
	dladdr((void *) on_load, & dl);
	g_szLibPath = wxFileName(UTF82String(dl.dli_fname)).GetPath(true);
}
#endif

wxString myMakeXMLName(const wxString & szFile)
{
#ifdef __LINUX__
	if (g_szLibPath.IsEmpty())
	{
		// 初回はライブラリが存在するディレクトリを取得。
		on_load();
	}
#endif
	return g_szLibPath + szFile + wxT(".xml");
}
#endif
