.file "Vane.S"
.code32
.text
.intel_syntax noprefix

.global clear_state,asm_move_cursol,write_mem8,VESA_640_480_SET,VESA_Check,VESA_Check,scrn320
.global io_hlt,io_cli,io_sti,io_stihlt
.global io_in8,io_in16,io_in32,io_out8,io_out16,io_out32
.global io_load_eflags,io_store_eflags,load_cr0,store_cr0,load_tr
.global farjmp

farjmp:
	JMP FAR [ESP+4]
	RET

io_hlt:
	HLT
	RET

io_cli:
	CLI
	RET

io_sti:
	STI
	RET

io_stihlt:
	STI
	HLT
	RET

io_in8:
	MOV	EDX,[ESP+4]
	MOV	EAX,0
	IN	AL,DX
	RET

io_in16:
	MOV	EDX,[ESP+4]
	MOV	EAX,0
	IN	AX,DX
	RET

io_in32:
	MOV	EDX,[ESP+4]
	IN	EAX,DX
	RET

io_out8:
	MOV	EDX,[ESP+4]
	MOV	AL,[ESP+8]
	OUT	DX,AL
	RET

io_out16:
	MOV	EDX,[ESP+4]
	MOV	EAX,[ESP+8]
	OUT	DX,AX
	RET

io_out32:
	MOV	EDX,[ESP+4]
	MOV	EAX,[ESP+8]
	OUT	DX,EAX
	RET

io_load_eflags:
	PUSHFD
	POP	EAX
	RET

io_store_eflags:
	MOV	EAX,[ESP+4]
	PUSH EAX
	POPFD
	RET

load_cr0:
	MOV	EAX,CR0
	RET

store_cr0:
	MOV	EAX,[ESP+4]
	MOV	CR0,EAX
	RET

load_tr:
	LTR	[ESP+4]
	RET


write_mem8:
	MOV ECX,[ESP+4]
	MOV AL,[ESP+8]
	MOV [ECX],AL
	RET

scrn320:
	MOV AL,0x13
	MOV AH,0x00
	INT 0x10
	
	RET

VESA_Check:
	MOV AX,0x9000
	MOV ES,AX
	MOV DI,0
	MOV AX,0x004F
	INT 0x10
	
	CMP AX,0x004F
	MOV EAX,0x01
	JNE scrn320
	MOV EAX,0x00
	RET

VESA_640_480_SET:
	MOV BX,0x0101
	MOV AX,0x4F02
	INT 0x10
	
	RET

clear_state:
	jmp 0x08:_flush_seg
	RET

_flush_seg:
	RET
	
asm_move_cursol:
	PUSH BP
	PUSH AX
	
	MOV AX,BP
	MOV DX,0x03D4
	MOV AL,0X0E
	
	OUT DX,AX
	
	POP AX
	
	MOV AH,AL
	MOV AL,0x0F
	
	OUT DX,AX
	
	MOV EAX,0
	
	RET

